/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.annotated;

import java.util.Locale;
import java.util.stream.Stream;
import net.jbock.annotated.AnnotatedMethod;
import net.jbock.annotated.AnnotatedOption;
import net.jbock.annotated.AnnotatedParameters;
import net.jbock.annotated.Executable;
import net.jbock.annotated.ExecutableParameter;
import net.jbock.common.EnumName;
import net.jbock.common.SnakeName;

public final class AnnotatedParameter
extends AnnotatedMethod {
    private final ExecutableParameter parameter;

    private AnnotatedParameter(EnumName enumName, ExecutableParameter parameter, String paramLabel) {
        super(enumName, paramLabel);
        this.parameter = parameter;
    }

    static AnnotatedParameter createParameter(ExecutableParameter parameter, EnumName enumName) {
        String paramLabel = parameter.paramLabel().orElseGet(() -> SnakeName.create(parameter.simpleName().toString()).snake('_').toUpperCase(Locale.US));
        return new AnnotatedParameter(enumName, parameter, paramLabel);
    }

    @Override
    Executable executable() {
        return this.parameter;
    }

    @Override
    public boolean isParameter() {
        return true;
    }

    @Override
    public boolean isParameters() {
        return false;
    }

    @Override
    Stream<AnnotatedOption> asAnnotatedOption() {
        return Stream.empty();
    }

    @Override
    Stream<AnnotatedParameter> asAnnotatedParameter() {
        return Stream.of(this);
    }

    @Override
    Stream<AnnotatedParameters> asAnnotatedParameters() {
        return Stream.empty();
    }

    public int index() {
        return this.parameter.index();
    }
}

