/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.annotated;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor9;
import net.jbock.Option;
import net.jbock.Parameter;
import net.jbock.Parameters;
import net.jbock.google.auto.common.AnnotationMirrors;
import net.jbock.google.auto.common.MoreTypes;

final class AnnotationUtil {
    private static final String CONVERTER_ATTRIBUTE = "converter";
    private static final Set<String> ANNOTATIONS = Stream.of(Parameter.class, Parameters.class, Option.class).map(Class::getCanonicalName).collect(Collectors.toSet());
    static final AnnotationValueVisitor<Optional<TypeMirror>, Void> GET_TYPE = new SimpleAnnotationValueVisitor9<Optional<TypeMirror>, Void>(){

        @Override
        public Optional<TypeMirror> visitType(TypeMirror mirror, Void nothing) {
            return Optional.of(mirror);
        }

        @Override
        protected Optional<TypeMirror> defaultAction(Object o, Void nothing) {
            return Optional.empty();
        }
    };

    AnnotationUtil() {
    }

    Optional<TypeElement> getConverterAttribute(ExecutableElement sourceMethod) {
        return this.getAnnotationMirror(sourceMethod).map(this::getAnnotationValue).flatMap(GET_TYPE::visit).map(MoreTypes::asTypeElement).filter(this::isNotVoid);
    }

    private Optional<AnnotationMirror> getAnnotationMirror(ExecutableElement sourceMethod) {
        return sourceMethod.getAnnotationMirrors().stream().filter(this::hasAnnotationTypeIn).map(a -> a).findFirst();
    }

    private boolean hasAnnotationTypeIn(AnnotationMirror annotation) {
        return ANNOTATIONS.contains(MoreTypes.asTypeElement(annotation.getAnnotationType()).getQualifiedName().toString());
    }

    private AnnotationValue getAnnotationValue(AnnotationMirror annotationMirror) {
        return AnnotationMirrors.getAnnotationValue(annotationMirror, CONVERTER_ATTRIBUTE);
    }

    private boolean isNotVoid(TypeElement typeElement) {
        return !"java.lang.Void".equals(typeElement.getQualifiedName().toString());
    }
}

