/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.annotated;

import java.lang.annotation.Annotation;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import net.jbock.Option;
import net.jbock.Parameter;
import net.jbock.Parameters;
import net.jbock.annotated.AnnotatedMethod;
import net.jbock.annotated.AnnotationUtil;
import net.jbock.annotated.ExecutableOption;
import net.jbock.annotated.ExecutableParameter;
import net.jbock.annotated.ExecutableParameters;
import net.jbock.common.Annotations;
import net.jbock.common.EnumName;
import net.jbock.common.ValidationFailure;
import net.jbock.processor.SourceElement;

abstract class Executable {
    private static final Set<Modifier> ACCESS_MODIFIERS = EnumSet.of(Modifier.PUBLIC, Modifier.PROTECTED);
    private static final AnnotationUtil ANNOTATION_UTIL = new AnnotationUtil();
    private final ExecutableElement method;

    Executable(ExecutableElement method) {
        this.method = method;
    }

    static Executable create(ExecutableElement method, Annotation annotation) {
        if (annotation instanceof Option) {
            return new ExecutableOption(method, (Option)annotation);
        }
        if (annotation instanceof Parameter) {
            return new ExecutableParameter(method, (Parameter)annotation);
        }
        if (annotation instanceof Parameters) {
            return new ExecutableParameters(method, (Parameters)annotation);
        }
        throw new AssertionError((Object)("expecting one of " + Annotations.methodLevelAnnotations() + " but found: " + annotation.getClass()));
    }

    abstract AnnotatedMethod annotatedMethod(SourceElement var1, EnumName var2);

    abstract Optional<String> descriptionKey();

    abstract List<String> description();

    final ExecutableElement method() {
        return this.method;
    }

    final Name simpleName() {
        return this.method.getSimpleName();
    }

    final List<Modifier> accessModifiers() {
        return this.method().getModifiers().stream().filter(ACCESS_MODIFIERS::contains).collect(Collectors.toList());
    }

    final Optional<TypeElement> converter() {
        return ANNOTATION_UTIL.getConverterAttribute(this.method);
    }

    final ValidationFailure fail(String message) {
        return new ValidationFailure(message, this.method);
    }
}

