/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.annotated;

import io.jbock.util.Either;
import io.jbock.util.Eithers;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import net.jbock.annotated.AnnotatedMethodsBuilder;
import net.jbock.annotated.Executable;
import net.jbock.common.Annotations;
import net.jbock.common.TypeTool;
import net.jbock.common.ValidationFailure;
import net.jbock.javax.inject.Inject;
import net.jbock.processor.SourceElement;
import net.jbock.validate.ValidateScope;

@ValidateScope
public class ExecutableElementsFinder {
    private final SourceElement sourceElement;

    @Inject
    ExecutableElementsFinder(SourceElement sourceElement) {
        this.sourceElement = sourceElement;
    }

    Either<List<ValidationFailure>, AnnotatedMethodsBuilder.Step2> findExecutableElements() {
        return this.checkInterfaceOrSimpleClass().or(this::checkNoInterfaces).map(List::of).map(Either::left).orElseGet(this::validParameterlessAbstract);
    }

    private Either<List<ValidationFailure>, AnnotatedMethodsBuilder.Step2> validParameterlessAbstract() {
        return ((Either)this.abstractMethods().stream().map(this::validateAbstractMethod).collect(Eithers.toValidListAll())).map(AnnotatedMethodsBuilder::builder).map(step -> step.sourceElement(this.sourceElement));
    }

    private Optional<ValidationFailure> checkInterfaceOrSimpleClass() {
        if (this.sourceElement.isInterface()) {
            return Optional.empty();
        }
        return TypeTool.AS_DECLARED.visit(this.sourceElement.element().getSuperclass()).map(DeclaredType::asElement).flatMap(TypeTool.AS_TYPE_ELEMENT::visit).flatMap(superClass -> superClass.getSuperclass().getKind() == TypeKind.NONE ? Optional.empty() : Optional.of(this.sourceElement.fail("invalid superclass: expecting java.lang.Object, but found: " + superClass.getQualifiedName())));
    }

    private Optional<ValidationFailure> checkNoInterfaces() {
        List<? extends TypeMirror> interfaces = this.sourceElement.element().getInterfaces();
        if (!interfaces.isEmpty()) {
            return Optional.of(this.sourceElement.fail("invalid command class: the command class or interface may not implement or extend any interfaces, but found: " + interfaces.stream().map(TypeTool.AS_DECLARED::visit).flatMap(Optional::stream).map(DeclaredType::asElement).map(Element::getSimpleName).map(Object::toString).collect(Collectors.toList())));
        }
        return Optional.empty();
    }

    private List<ExecutableElement> abstractMethods() {
        return ElementFilter.methodsIn(this.sourceElement.element().getEnclosedElements()).stream().filter(m -> m.getModifiers().contains((Object)Modifier.ABSTRACT)).collect(Collectors.toList());
    }

    private Either<ValidationFailure, Executable> validateAbstractMethod(ExecutableElement method) {
        return this.getMethodAnnotation(method).map(a -> Either.right((Object)Executable.create(method, a))).orElseGet(() -> Either.left((Object)this.missingAnnotationError(method))).filter(this::validateParameterless);
    }

    private Optional<? extends Annotation> getMethodAnnotation(ExecutableElement method) {
        return Annotations.methodLevelAnnotations().stream().map(method::getAnnotation).filter(Objects::nonNull).findFirst();
    }

    private Optional<ValidationFailure> validateParameterless(Executable method) {
        if (method.method().getParameters().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(method.fail("invalid method parameters: abstract method '" + method.method().getSimpleName() + "' may not have any parameters, but found: " + method.method().getParameters().stream().map(VariableElement::getSimpleName).map(Object::toString).collect(Collectors.toList())));
    }

    private ValidationFailure missingAnnotationError(ExecutableElement m) {
        String message = "missing annotation: add one of these annotations: " + Annotations.methodLevelAnnotations().stream().map(Class::getSimpleName).collect(Collectors.toList());
        message = message + " to method '" + m.getSimpleName() + "'";
        return new ValidationFailure(message, m);
    }
}

