/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.common;

import java.util.Locale;
import java.util.regex.Pattern;

public class EnumName {
    private static final Pattern ENDS_WITH_NUMBER = Pattern.compile(".*\\d");
    private final String enumConstant;
    private final String original;

    private EnumName(String original, String enumConstant) {
        this.original = original;
        this.enumConstant = enumConstant;
    }

    public static EnumName create(String input) {
        if ("_".equals(input)) {
            return new EnumName("__", "__");
        }
        return new EnumName(input, input.toUpperCase(Locale.US));
    }

    public EnumName makeLonger() {
        String appendage = ENDS_WITH_NUMBER.matcher(this.enumConstant).matches() ? "1" : "_1";
        return new EnumName(this.original + appendage, this.enumConstant + appendage);
    }

    public String enumConstant() {
        return this.enumConstant;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumName other = (EnumName)o;
        return this.enumConstant.equals(other.enumConstant);
    }

    public int hashCode() {
        return this.enumConstant.hashCode();
    }
}

