/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.common;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import net.jbock.common.SafeTypes;
import net.jbock.common.TypeTool;
import net.jbock.common.ValidationFailure;

public class Util {
    private final SafeTypes types;
    private final TypeTool tool;

    public Util(SafeTypes types, TypeTool tool) {
        this.types = types;
        this.tool = tool;
    }

    public Optional<ValidationFailure> commonTypeChecks(TypeElement classToCheck) {
        return this.checkNesting(classToCheck).map(f -> f.prepend("invalid class: ")).or(() -> this.checkDefaultConstructor(classToCheck));
    }

    private Optional<ValidationFailure> checkNesting(TypeElement classToCheck) {
        if (classToCheck.getNestingKind().isNested() && !classToCheck.getModifiers().contains((Object)Modifier.STATIC)) {
            return Optional.of(new ValidationFailure("nested class '" + classToCheck.getSimpleName() + "' must be static", classToCheck));
        }
        if (classToCheck.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return Optional.of(new ValidationFailure("class '" + classToCheck.getSimpleName() + " may not be private", classToCheck));
        }
        for (TypeElement element : this.getEnclosingElements(classToCheck)) {
            if (!element.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            return Optional.of(new ValidationFailure("enclosing class '" + element.getSimpleName() + "' may not be private", classToCheck));
        }
        return Optional.empty();
    }

    private Optional<ValidationFailure> checkDefaultConstructor(TypeElement classToCheck) {
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(classToCheck.getEnclosedElements());
        if (constructors.isEmpty()) {
            return Optional.empty();
        }
        return constructors.stream().filter(c -> c.getParameters().isEmpty()).map(c -> {
            if (c.getModifiers().contains((Object)Modifier.PRIVATE)) {
                return Optional.of(new ValidationFailure("invalid constructor: visibility may not be private", (Element)c));
            }
            return this.checkExceptionsInDeclaration((ExecutableElement)c);
        }).flatMap(Optional::stream).findAny().or(() -> {
            if (constructors.stream().anyMatch(c -> c.getParameters().isEmpty())) {
                return Optional.empty();
            }
            return Optional.of(new ValidationFailure("invalid converter class: default constructor not found", classToCheck));
        });
    }

    public Optional<ValidationFailure> checkExceptionsInDeclaration(ExecutableElement element) {
        return element.getThrownTypes().stream().map(thrown -> this.checkChecked(element, (TypeMirror)thrown, (TypeMirror)thrown)).flatMap(Optional::stream).findAny();
    }

    private Optional<ValidationFailure> checkChecked(ExecutableElement element, TypeMirror thrown, TypeMirror mirror) {
        if (this.tool.isSameType(mirror, RuntimeException.class) || this.tool.isSameType(mirror, Error.class)) {
            return Optional.empty();
        }
        if (this.tool.isSameType(mirror, Throwable.class)) {
            return Optional.of(new ValidationFailure("invalid throws clause: found checked exception " + this.typeToString(thrown), element));
        }
        return this.types.asElement(mirror).flatMap(TypeTool.AS_TYPE_ELEMENT::visit).flatMap(t -> this.checkNesting((TypeElement)t).map(f -> f.prepend("invalid throws clause: declared exception " + this.typeToString(thrown) + " is invalid: ").about(element)).or(() -> this.checkChecked(element, thrown, t.getSuperclass())));
    }

    public List<TypeElement> getEnclosingElements(TypeElement sourceElement) {
        LinkedList<TypeElement> result = new LinkedList<TypeElement>();
        result.add(sourceElement);
        while (((TypeElement)result.getLast()).getNestingKind() == NestingKind.MEMBER) {
            Element enclosingElement = ((TypeElement)result.getLast()).getEnclosingElement();
            TypeTool.AS_TYPE_ELEMENT.visit(enclosingElement).ifPresent(result::add);
        }
        return new ArrayList<TypeElement>(result);
    }

    public String typeToString(TypeMirror type) {
        return TypeTool.AS_DECLARED.visit(type).flatMap(declared -> TypeTool.AS_TYPE_ELEMENT.visit(declared.asElement()).map(t -> {
            String base = t.getSimpleName().toString();
            if (declared.getTypeArguments().isEmpty()) {
                return base;
            }
            return base + declared.getTypeArguments().stream().map(this::typeToString).collect(Collectors.joining(", ", "<", ">"));
        })).orElseGet(type::toString);
    }

    public Optional<ValidationFailure> checkNoDuplicateAnnotations(ExecutableElement element, List<Class<? extends Annotation>> annotations) {
        List present = annotations.stream().filter(ann -> element.getAnnotation(ann) != null).collect(Collectors.toList());
        if (present.size() >= 2) {
            return Optional.of(new ValidationFailure("annotate with either @" + ((Class)present.get(0)).getSimpleName() + " or @" + ((Class)present.get(1)).getSimpleName() + " but not both", element));
        }
        return Optional.empty();
    }

    public SafeTypes types() {
        return this.types;
    }
}

