/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.context;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jbock.annotated.AnnotatedOption;
import net.jbock.annotated.AnnotatedParameter;
import net.jbock.annotated.AnnotatedParameters;
import net.jbock.context.CommonFields;
import net.jbock.context.ContextScope;
import net.jbock.convert.Mapping;
import net.jbock.dagger.Module;
import net.jbock.dagger.Provides;
import net.jbock.processor.SourceElement;

@Module
public class ContextModule {
    private final SourceElement sourceElement;
    private final List<Mapping<AnnotatedParameter>> positionalParams;
    private final List<Mapping<AnnotatedParameters>> repeatablePositionalParameters;
    private final List<Mapping<AnnotatedOption>> namedOptions;

    public ContextModule(SourceElement sourceElement, List<Mapping<AnnotatedParameter>> positionalParams, List<Mapping<AnnotatedParameters>> repeatablePositionalParameters, List<Mapping<AnnotatedOption>> namedOptions) {
        this.sourceElement = sourceElement;
        this.positionalParams = positionalParams;
        this.repeatablePositionalParameters = repeatablePositionalParameters;
        this.namedOptions = namedOptions;
    }

    @ContextScope
    @Provides
    SourceElement sourceElement() {
        return this.sourceElement;
    }

    @ContextScope
    @Provides
    List<Mapping<AnnotatedParameters>> repeatablePositionalParameters() {
        return this.repeatablePositionalParameters;
    }

    @ContextScope
    @Provides
    List<Mapping<AnnotatedParameter>> positionalParameters() {
        return this.positionalParams;
    }

    @ContextScope
    @Provides
    List<Mapping<AnnotatedOption>> getNamedOptions() {
        return this.namedOptions;
    }

    @ContextScope
    @Provides
    List<Mapping<?>> allMappings() {
        return Stream.of(this.namedOptions, this.positionalParams, this.repeatablePositionalParameters).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @ContextScope
    @Provides
    CommonFields commonFields(SourceElement sourceElement) {
        return CommonFields.create(sourceElement, this.namedOptions);
    }
}

