/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.context;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.jbock.annotated.AnnotatedMethod;
import net.jbock.annotated.AnnotatedOption;
import net.jbock.annotated.AnnotatedParameter;
import net.jbock.annotated.AnnotatedParameters;
import net.jbock.context.Cached;
import net.jbock.context.ContextScope;
import net.jbock.context.ContextUtil;
import net.jbock.convert.Mapping;
import net.jbock.javapoet.CodeBlock;
import net.jbock.javapoet.MethodSpec;
import net.jbock.javax.inject.Inject;
import net.jbock.model.CommandModel;
import net.jbock.model.Multiplicity;
import net.jbock.model.Option;
import net.jbock.model.Parameter;
import net.jbock.processor.SourceElement;

@ContextScope
public final class CreateModelMethod
extends Cached<MethodSpec> {
    private final ContextUtil contextUtil;
    private final SourceElement sourceElement;
    private final List<Mapping<AnnotatedOption>> namedOptions;
    private final List<Mapping<AnnotatedParameter>> positionalParameters;
    private final List<Mapping<AnnotatedParameters>> repeatablePositionalParameters;

    @Inject
    CreateModelMethod(ContextUtil contextUtil, SourceElement sourceElement, List<Mapping<AnnotatedOption>> namedOptions, List<Mapping<AnnotatedParameter>> positionalParameters, List<Mapping<AnnotatedParameters>> repeatablePositionalParameters) {
        this.contextUtil = contextUtil;
        this.sourceElement = sourceElement;
        this.namedOptions = namedOptions;
        this.positionalParameters = positionalParameters;
        this.repeatablePositionalParameters = repeatablePositionalParameters;
    }

    @Override
    MethodSpec define() {
        ArrayList<CodeBlock> code = new ArrayList<CodeBlock>();
        code.add(CodeBlock.of("return $T.builder()", CommandModel.class));
        this.sourceElement.descriptionKey().ifPresent(key -> code.add(CodeBlock.of(".withDescriptionKey($S)", key)));
        for (String string : this.sourceElement.description()) {
            code.add(CodeBlock.of(".addDescriptionLine($S)", string));
        }
        code.add(CodeBlock.of(".withProgramName($S)", this.sourceElement.programName()));
        if (this.sourceElement.isSuperCommand()) {
            code.add(CodeBlock.of(".withSuperCommand($L)", true));
        }
        for (Mapping mapping : this.namedOptions) {
            code.add(CodeBlock.of(".addOption($L)", this.optionBlock(mapping)));
        }
        Stream.of(this.positionalParameters, this.repeatablePositionalParameters).flatMap(Collection::stream).forEach(c -> code.add(CodeBlock.of(".addParameter($L)", this.parameterBlock((Mapping<?>)c))));
        code.add(CodeBlock.of(".build()", new Object[0]));
        return MethodSpec.methodBuilder("createModel").addStatement(this.contextUtil.joinByNewline(code)).returns((Type)((Object)CommandModel.class)).addModifiers(this.sourceElement.accessModifiers()).build();
    }

    private CodeBlock optionBlock(Mapping<AnnotatedOption> m) {
        ArrayList<CodeBlock> names = new ArrayList<CodeBlock>();
        for (String name : m.sourceMethod().names()) {
            names.add(CodeBlock.of("$S", name));
        }
        ArrayList<CodeBlock> code = new ArrayList<CodeBlock>();
        if (m.isModeFlag()) {
            code.add(CodeBlock.of("$T.nullary()", Option.class));
        } else {
            code.add(CodeBlock.of("$T.unary($T.$L)", Option.class, Multiplicity.class, m.multiplicity().name()));
        }
        code.add(CodeBlock.of(".withParamLabel($S)", m.paramLabel()));
        m.sourceMethod().descriptionKey().ifPresent(key -> code.add(CodeBlock.of(".withDescriptionKey($S)", key)));
        code.add(CodeBlock.of(".withNames($T.of($L))", List.class, this.contextUtil.joinByComma(names)));
        for (String line : m.sourceMethod().description()) {
            code.add(CodeBlock.of(".addDescriptionLine($S)", line));
        }
        code.add(CodeBlock.of(".build()", new Object[0]));
        return this.contextUtil.joinByNewline(code);
    }

    private CodeBlock parameterBlock(Mapping<?> m) {
        ArrayList<CodeBlock> code = new ArrayList<CodeBlock>();
        code.add(CodeBlock.of("$T.builder($T.$L)", Parameter.class, Multiplicity.class, m.multiplicity().name()));
        code.add(CodeBlock.of(".withParamLabel($S)", m.paramLabel()));
        ((AnnotatedMethod)m.sourceMethod()).descriptionKey().ifPresent(key -> code.add(CodeBlock.of(".withDescriptionKey($S)", key)));
        for (String line : ((AnnotatedMethod)m.sourceMethod()).description()) {
            code.add(CodeBlock.of(".addDescriptionLine($S)", line));
        }
        code.add(CodeBlock.of(".build()", new Object[0]));
        return this.contextUtil.joinByNewline(code);
    }
}

