/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.context;

import java.util.Optional;
import net.jbock.common.Constants;
import net.jbock.context.ContextScope;
import net.jbock.javapoet.ClassName;
import net.jbock.javapoet.ParameterizedTypeName;
import net.jbock.javapoet.TypeName;
import net.jbock.javax.inject.Inject;
import net.jbock.processor.SourceElement;
import net.jbock.util.ParsingFailed;
import net.jbock.util.SuperResult;

@ContextScope
public class GeneratedTypes {
    private final SourceElement sourceElement;
    private final ClassName generatedClass;

    @Inject
    GeneratedTypes(SourceElement sourceElement) {
        this.sourceElement = sourceElement;
        this.generatedClass = sourceElement.generatedClass();
    }

    TypeName parseSuccessType() {
        return this.superResultType().orElse(this.sourceElement.typeName());
    }

    Optional<TypeName> superResultType() {
        if (!this.sourceElement.isSuperCommand()) {
            return Optional.empty();
        }
        ParameterizedTypeName type = ParameterizedTypeName.get(ClassName.get(SuperResult.class), this.sourceElement.typeName());
        return Optional.of(type);
    }

    ClassName implType() {
        return this.generatedClass.peerClass(this.sourceElement.element().getSimpleName() + "_Impl");
    }

    TypeName parseResultType() {
        return ParameterizedTypeName.get(Constants.EITHER, ClassName.get(ParsingFailed.class), this.parseSuccessType());
    }
}

