/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.context;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Modifier;
import net.jbock.annotated.AnnotatedMethod;
import net.jbock.annotated.AnnotatedOption;
import net.jbock.annotated.AnnotatedParameter;
import net.jbock.annotated.AnnotatedParameters;
import net.jbock.common.Constants;
import net.jbock.context.Cached;
import net.jbock.context.ContextScope;
import net.jbock.context.ContextUtil;
import net.jbock.context.GeneratedTypes;
import net.jbock.context.ParserTypeFactory;
import net.jbock.convert.Mapping;
import net.jbock.google.common.base.Preconditions;
import net.jbock.javapoet.ArrayTypeName;
import net.jbock.javapoet.CodeBlock;
import net.jbock.javapoet.MethodSpec;
import net.jbock.javapoet.ParameterSpec;
import net.jbock.javapoet.TypeName;
import net.jbock.javax.inject.Inject;
import net.jbock.model.ItemType;
import net.jbock.processor.SourceElement;
import net.jbock.util.ExConvert;
import net.jbock.util.ExFailure;
import net.jbock.util.ExMissingItem;

@ContextScope
public final class HarvestMethod
extends Cached<MethodSpec> {
    private final GeneratedTypes generatedTypes;
    private final SourceElement sourceElement;
    private final List<Mapping<AnnotatedOption>> namedOptions;
    private final List<Mapping<AnnotatedParameter>> positionalParameters;
    private final List<Mapping<AnnotatedParameters>> repeatablePositionalParameters;
    private final ContextUtil contextUtil;
    private final ParserTypeFactory parserTypeFactory;
    private final ParameterSpec left = ParameterSpec.builder(Constants.STRING, "left", new Modifier[0]).build();

    @Inject
    HarvestMethod(GeneratedTypes generatedTypes, SourceElement sourceElement, List<Mapping<AnnotatedOption>> namedOptions, List<Mapping<AnnotatedParameter>> positionalParameters, List<Mapping<AnnotatedParameters>> repeatablePositionalParameters, ContextUtil contextUtil, ParserTypeFactory parserTypeFactory) {
        this.generatedTypes = generatedTypes;
        this.sourceElement = sourceElement;
        this.namedOptions = namedOptions;
        this.positionalParameters = positionalParameters;
        this.repeatablePositionalParameters = repeatablePositionalParameters;
        this.contextUtil = contextUtil;
        this.parserTypeFactory = parserTypeFactory;
    }

    @Override
    MethodSpec define() {
        ParameterSpec p;
        Mapping<AnnotatedMethod> m2;
        int i;
        ParameterSpec parser = this.parserTypeFactory.define().asParam();
        CodeBlock constructorArguments = this.getConstructorArguments();
        MethodSpec.Builder spec = MethodSpec.methodBuilder("harvest");
        for (i = 0; i < this.namedOptions.size(); ++i) {
            m2 = this.namedOptions.get(i);
            p = this.asParam(m2);
            spec.addStatement("$T $N = $L", p.type, p, this.convertExpressionOption(m2, i));
        }
        for (i = 0; i < this.positionalParameters.size(); ++i) {
            m2 = this.positionalParameters.get(i);
            p = this.asParam(m2);
            spec.addStatement("$T $N = $L", p.type, p, this.convertExpressionRegularParameter(m2, i));
        }
        this.repeatablePositionalParameters.forEach(m -> {
            ParameterSpec p = this.asParam((Mapping<?>)m);
            spec.addStatement("$T $N = $L", p.type, p, this.convertExpressionRepeatableParameter((Mapping<AnnotatedParameters>)m));
        });
        this.generatedTypes.superResultType().ifPresentOrElse(parseResultWithRestType -> {
            ParameterSpec result = ParameterSpec.builder(this.sourceElement.typeName(), "result", new Modifier[0]).build();
            ParameterSpec restArgs = ParameterSpec.builder(this.sourceElement.typeName(), "restArgs", new Modifier[0]).build();
            spec.addStatement("$T $N = new $T($L)", result.type, result, this.generatedTypes.implType(), constructorArguments);
            spec.addStatement("$T $N = $N.rest().toArray($T::new)", Constants.STRING_ARRAY, restArgs, parser, ArrayTypeName.of(String.class));
            spec.addStatement("return new $T($N, $N)", parseResultWithRestType, result, restArgs);
        }, () -> spec.addStatement("return new $T($L)", this.generatedTypes.implType(), constructorArguments));
        return spec.returns(this.generatedTypes.parseSuccessType()).addParameter(parser).addException((Type)((Object)ExFailure.class)).addModifiers(Modifier.PRIVATE).build();
    }

    private CodeBlock getConstructorArguments() {
        ArrayList<CodeBlock> code = new ArrayList<CodeBlock>();
        for (Mapping<AnnotatedOption> mapping : this.namedOptions) {
            code.add(CodeBlock.of("$N", this.asParam(mapping)));
        }
        for (Mapping<AnnotatedMethod> mapping : this.positionalParameters) {
            code.add(CodeBlock.of("$N", this.asParam(mapping)));
        }
        this.repeatablePositionalParameters.stream().map(m -> CodeBlock.of("$N", this.asParam((Mapping<?>)m))).forEach(code::add);
        return this.contextUtil.joinByComma(code);
    }

    private CodeBlock convertExpressionOption(Mapping<AnnotatedOption> m, int i) {
        ParameterSpec parser = this.parserTypeFactory.define().asParam();
        ArrayList<CodeBlock> code = new ArrayList<CodeBlock>();
        code.add(CodeBlock.of("$N.option($T.$N)", parser, this.sourceElement.optionEnumType(), m.enumName().enumConstant()));
        if (!m.isModeFlag()) {
            code.add(CodeBlock.of(".map($L)", m.mapper()));
        }
        code.addAll(this.tailExpressionOption(m, i));
        m.extractExpr().ifPresent(code::add);
        return this.contextUtil.joinByNewline(code);
    }

    private CodeBlock convertExpressionRegularParameter(Mapping<AnnotatedParameter> m, int i) {
        ParameterSpec parser = this.parserTypeFactory.define().asParam();
        ArrayList<CodeBlock> code = new ArrayList<CodeBlock>();
        code.add(CodeBlock.of("$N.param($L)", parser, m.sourceMethod().index()));
        code.add(CodeBlock.of(".map($L)", m.mapper()));
        code.addAll(this.tailExpressionParameter(m, i));
        m.extractExpr().ifPresent(code::add);
        return this.contextUtil.joinByNewline(code);
    }

    private CodeBlock convertExpressionRepeatableParameter(Mapping<AnnotatedParameters> m) {
        ParameterSpec parser = this.parserTypeFactory.define().asParam();
        ArrayList<CodeBlock> code = new ArrayList<CodeBlock>();
        code.add(CodeBlock.of("$N.rest()", parser));
        code.add(CodeBlock.of(".map($L)", m.mapper()));
        code.add(CodeBlock.of(".collect($T.toValidList())", Constants.EITHERS));
        code.add(this.orElseThrowConverterError(ItemType.PARAMETER, this.positionalParameters.size()));
        return this.contextUtil.joinByNewline(code);
    }

    private List<CodeBlock> tailExpressionOption(Mapping<AnnotatedOption> m, int i) {
        if (m.isModeFlag()) {
            return List.of(CodeBlock.of(".findAny().isPresent()", new Object[0]));
        }
        switch (m.multiplicity()) {
            case REQUIRED: {
                return List.of(CodeBlock.of(".findAny()", new Object[0]), CodeBlock.of(".orElseThrow(() -> new $T($T.$L, $L))", ExMissingItem.class, ItemType.class, ItemType.OPTION, i), this.orElseThrowConverterError(ItemType.OPTION, i));
            }
            case OPTIONAL: {
                return List.of(CodeBlock.of(".collect($T.toValidList())", Constants.EITHERS), this.orElseThrowConverterError(ItemType.OPTION, i), CodeBlock.of(".stream().findAny()", new Object[0]));
            }
        }
        Preconditions.checkArgument(m.isRepeatable());
        return List.of(CodeBlock.of(".collect($T.toValidList())", Constants.EITHERS), this.orElseThrowConverterError(ItemType.OPTION, i));
    }

    private List<CodeBlock> tailExpressionParameter(Mapping<AnnotatedParameter> m, int i) {
        if (m.isRequired()) {
            return List.of(CodeBlock.of(".orElseThrow(() -> new $T($T.$L, $L))", ExMissingItem.class, ItemType.class, ItemType.PARAMETER, i), this.orElseThrowConverterError(ItemType.PARAMETER, i));
        }
        Preconditions.checkArgument(m.isOptional());
        return List.of(CodeBlock.of(".stream()", new Object[0]), CodeBlock.of(".collect($T.toValidList())", Constants.EITHERS), this.orElseThrowConverterError(ItemType.PARAMETER, i), CodeBlock.of(".stream().findAny()", new Object[0]));
    }

    private CodeBlock orElseThrowConverterError(ItemType itemType, int i) {
        return CodeBlock.of(".orElseThrow($1N -> new $2T($1N, $3T.$4L, $5L))", this.left, ExConvert.class, ItemType.class, itemType, i);
    }

    private ParameterSpec asParam(Mapping<?> mapping) {
        TypeName type = TypeName.get(((AnnotatedMethod)mapping.sourceMethod()).returnType());
        String name = ((AnnotatedMethod)mapping.sourceMethod()).methodName();
        return ParameterSpec.builder(type, "_" + name, new Modifier[0]).build();
    }
}

