/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.context;

import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import net.jbock.annotated.AnnotatedMethod;
import net.jbock.context.ContextScope;
import net.jbock.context.GeneratedAnnotation;
import net.jbock.context.GeneratedTypes;
import net.jbock.convert.Mapping;
import net.jbock.javapoet.FieldSpec;
import net.jbock.javapoet.MethodSpec;
import net.jbock.javapoet.ParameterSpec;
import net.jbock.javapoet.TypeName;
import net.jbock.javapoet.TypeSpec;
import net.jbock.javax.inject.Inject;
import net.jbock.processor.SourceElement;

@ContextScope
public class ImplClass {
    private final GeneratedTypes generatedTypes;
    private final SourceElement sourceElement;
    private final List<Mapping<?>> allMappings;
    private final GeneratedAnnotation generatedAnnotation;

    @Inject
    ImplClass(GeneratedTypes generatedTypes, SourceElement sourceElement, List<Mapping<?>> allMappings, GeneratedAnnotation generatedAnnotation) {
        this.generatedTypes = generatedTypes;
        this.sourceElement = sourceElement;
        this.allMappings = allMappings;
        this.generatedAnnotation = generatedAnnotation;
    }

    public TypeSpec define() {
        TypeSpec.Builder spec = TypeSpec.classBuilder(this.generatedTypes.implType());
        if (this.sourceElement.isInterface()) {
            spec.addSuperinterface(this.sourceElement.typeName());
        } else {
            spec.superclass(this.sourceElement.typeName());
        }
        return spec.addModifiers(Modifier.FINAL).addOriginatingElement(this.sourceElement.element()).addMethod(this.implConstructor()).addAnnotation(this.generatedAnnotation.define()).addFields(this.allMappings.stream().map(this::asField).collect(Collectors.toList())).addMethods(this.allMappings.stream().map(this::parameterMethodOverride).collect(Collectors.toList())).build();
    }

    private MethodSpec parameterMethodOverride(Mapping<?> m) {
        Object sourceMethod = m.sourceMethod();
        return MethodSpec.methodBuilder(((AnnotatedMethod)sourceMethod).methodName()).returns(TypeName.get(((AnnotatedMethod)sourceMethod).returnType())).addModifiers(((AnnotatedMethod)sourceMethod).accessModifiers()).addStatement("return $N", this.asField(m)).addAnnotation(Override.class).build();
    }

    private MethodSpec implConstructor() {
        MethodSpec.Builder spec = MethodSpec.constructorBuilder();
        for (Mapping<?> m : this.allMappings) {
            FieldSpec field = this.asField(m);
            ParameterSpec param = ParameterSpec.builder(field.type, ((AnnotatedMethod)m.sourceMethod()).methodName(), new Modifier[0]).build();
            spec.addStatement("this.$N = $N", field, param);
            spec.addParameter(param);
        }
        return spec.build();
    }

    private FieldSpec asField(Mapping<?> mapping) {
        TypeName fieldType = TypeName.get(((AnnotatedMethod)mapping.sourceMethod()).returnType());
        String fieldName = ((AnnotatedMethod)mapping.sourceMethod()).methodName();
        return FieldSpec.builder(fieldType, fieldName, new Modifier[0]).addModifiers(Modifier.PRIVATE, Modifier.FINAL).build();
    }
}

