/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.context;

import java.util.List;
import javax.lang.model.element.Modifier;
import net.jbock.annotated.AnnotatedOption;
import net.jbock.common.EnumName;
import net.jbock.context.ContextScope;
import net.jbock.convert.Mapping;
import net.jbock.javapoet.TypeSpec;
import net.jbock.javax.inject.Inject;
import net.jbock.processor.SourceElement;

@ContextScope
public class OptEnum {
    private final List<Mapping<AnnotatedOption>> options;
    private final SourceElement sourceElement;

    @Inject
    OptEnum(List<Mapping<AnnotatedOption>> options, SourceElement sourceElement) {
        this.options = options;
        this.sourceElement = sourceElement;
    }

    TypeSpec define() {
        TypeSpec.Builder spec = TypeSpec.enumBuilder(this.sourceElement.optionEnumType());
        for (Mapping<AnnotatedOption> option : this.options) {
            EnumName enumName = option.enumName();
            String enumConstant = enumName.enumConstant();
            spec.addEnumConstant(enumConstant);
        }
        return spec.addModifiers(Modifier.PRIVATE).build();
    }
}

