/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.context;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import net.jbock.annotated.AnnotatedOption;
import net.jbock.context.Cached;
import net.jbock.context.CommonFields;
import net.jbock.context.ContextScope;
import net.jbock.convert.Mapping;
import net.jbock.javapoet.CodeBlock;
import net.jbock.javapoet.MethodSpec;
import net.jbock.javapoet.ParameterSpec;
import net.jbock.javax.inject.Inject;
import net.jbock.processor.SourceElement;

@ContextScope
public final class OptionNamesMethod
extends Cached<MethodSpec> {
    private final List<Mapping<AnnotatedOption>> namedOptions;
    private final SourceElement sourceElement;
    private final CommonFields commonFields;

    @Inject
    OptionNamesMethod(List<Mapping<AnnotatedOption>> namedOptions, SourceElement sourceElement, CommonFields commonFields) {
        this.namedOptions = namedOptions;
        this.sourceElement = sourceElement;
        this.commonFields = commonFields;
    }

    @Override
    MethodSpec define() {
        ParameterSpec result = ParameterSpec.builder(this.commonFields.optionNames().type, "result", new Modifier[0]).build();
        CodeBlock code = this.namedOptions.isEmpty() ? CodeBlock.builder().addStatement("return $T.of()", Map.class).build() : this.regularCode(result);
        return MethodSpec.methodBuilder("optionNames").addCode(code).returns(result.type).addModifiers(Modifier.PRIVATE, Modifier.STATIC).build();
    }

    private CodeBlock regularCode(ParameterSpec result) {
        long mapSize = this.namedOptions.stream().map(Mapping::sourceMethod).map(AnnotatedOption::names).map(List::size).mapToLong(i -> i.intValue()).sum();
        CodeBlock.Builder code = CodeBlock.builder();
        code.addStatement("$T $N = new $T<>($L)", result.type, result, HashMap.class, mapSize);
        for (Mapping<AnnotatedOption> namedOption : this.namedOptions) {
            String enumConstant = namedOption.enumName().enumConstant();
            for (String dashedName : namedOption.sourceMethod().names()) {
                code.addStatement("$N.put($S, $T.$L)", result, dashedName, this.sourceElement.optionEnumType(), enumConstant);
            }
        }
        code.addStatement("return $N", result);
        return code.build();
    }
}

