/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.context;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import net.jbock.annotated.AnnotatedOption;
import net.jbock.common.Constants;
import net.jbock.context.Cached;
import net.jbock.context.CommonFields;
import net.jbock.context.ContextScope;
import net.jbock.convert.Mapping;
import net.jbock.javapoet.ClassName;
import net.jbock.javapoet.CodeBlock;
import net.jbock.javapoet.MethodSpec;
import net.jbock.javapoet.ParameterSpec;
import net.jbock.javax.inject.Inject;
import net.jbock.parse.OptionState;
import net.jbock.parse.OptionStateModeFlag;
import net.jbock.parse.OptionStateNonRepeatable;
import net.jbock.parse.OptionStateRepeatable;
import net.jbock.processor.SourceElement;

@ContextScope
public final class OptionStatesMethod
extends Cached<MethodSpec> {
    private final List<Mapping<AnnotatedOption>> namedOptions;
    private final SourceElement sourceElement;
    private final CommonFields commonFields;

    @Inject
    OptionStatesMethod(List<Mapping<AnnotatedOption>> namedOptions, SourceElement sourceElement, CommonFields commonFields) {
        this.namedOptions = namedOptions;
        this.sourceElement = sourceElement;
        this.commonFields = commonFields;
    }

    @Override
    MethodSpec define() {
        ParameterSpec result = ParameterSpec.builder(Constants.mapOf(this.commonFields.optType(), ClassName.get(OptionState.class)), "result", new Modifier[0]).build();
        CodeBlock code = this.namedOptions.isEmpty() ? CodeBlock.builder().addStatement("return $T.of()", Map.class).build() : this.regularCode(result);
        return MethodSpec.methodBuilder("optionStates").addCode(code).returns(result.type).addModifiers(Modifier.PRIVATE).build();
    }

    private CodeBlock regularCode(ParameterSpec result) {
        CodeBlock.Builder code = CodeBlock.builder();
        code.addStatement("$T $N = new $T<>($T.class)", result.type, result, EnumMap.class, this.sourceElement.optionEnumType());
        for (Mapping<AnnotatedOption> namedOption : this.namedOptions) {
            String enumConstant = namedOption.enumName().enumConstant();
            code.addStatement("$N.put($T.$L, new $T())", result, this.sourceElement.optionEnumType(), enumConstant, this.optionParserType(namedOption));
        }
        code.addStatement("return $N", result);
        return code.build();
    }

    private ClassName optionParserType(Mapping<AnnotatedOption> param) {
        if (param.isRepeatable()) {
            return ClassName.get(OptionStateRepeatable.class);
        }
        if (param.isModeFlag()) {
            return ClassName.get(OptionStateModeFlag.class);
        }
        return ClassName.get(OptionStateNonRepeatable.class);
    }
}

