/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.context;

import java.util.List;
import javax.lang.model.element.Modifier;
import net.jbock.common.Constants;
import net.jbock.context.ContextScope;
import net.jbock.context.CreateModelMethod;
import net.jbock.context.GeneratedTypes;
import net.jbock.context.ParseMethod;
import net.jbock.contrib.StandardErrorHandler;
import net.jbock.convert.Mapping;
import net.jbock.javapoet.CodeBlock;
import net.jbock.javapoet.MethodSpec;
import net.jbock.javapoet.ParameterSpec;
import net.jbock.javax.inject.Inject;
import net.jbock.processor.SourceElement;
import net.jbock.util.AtFileError;
import net.jbock.util.ParseRequest;

@ContextScope
public class ParseOrExitMethod {
    private final SourceElement sourceElement;
    private final GeneratedTypes generatedTypes;
    private final ParseMethod parseMethod;
    private final List<Mapping<?>> allMappings;
    private final CreateModelMethod createModelMethod;

    @Inject
    ParseOrExitMethod(SourceElement sourceElement, GeneratedTypes generatedTypes, ParseMethod parseMethod, List<Mapping<?>> allMappings, CreateModelMethod createModelMethod) {
        this.sourceElement = sourceElement;
        this.generatedTypes = generatedTypes;
        this.parseMethod = parseMethod;
        this.allMappings = allMappings;
        this.createModelMethod = createModelMethod;
    }

    MethodSpec define() {
        ParameterSpec args = ParameterSpec.builder(Constants.STRING_ARRAY, "args", new Modifier[0]).build();
        ParameterSpec notSuccess = ParameterSpec.builder(this.generatedTypes.parseResultType(), "failure", new Modifier[0]).build();
        ParameterSpec err = ParameterSpec.builder(AtFileError.class, "err", new Modifier[0]).build();
        CodeBlock.Builder code = CodeBlock.builder();
        if (this.allMappings.stream().anyMatch(Mapping::isRequired)) {
            code.beginControlFlow("if ($1N.length == 0 || $2S.equals($1N[0]))", args, "--help").add("$T.builder().build()\n", StandardErrorHandler.class).indent().add(".printUsageDocumentation($N());\n", this.createModelMethod.get()).unindent().addStatement("$T.exit(0)", System.class).endControlFlow();
        } else {
            code.beginControlFlow("if ($1N.length > 0 && $2S.equals($1N[0]))", args, "--help").add("$T.builder().build()\n", StandardErrorHandler.class).indent().add(".printUsageDocumentation($N());\n", this.createModelMethod.get()).unindent().addStatement("$T.exit(0)", System.class).endControlFlow();
        }
        code.add("return $T.from($N).expand()\n", ParseRequest.class, args).indent().add(".mapLeft($1N -> $1N.addModel($2N()))\n", err, this.createModelMethod.get()).add(".flatMap(this::$N)\n", this.parseMethod.get()).add(".orElseThrow($N -> {\n", notSuccess).indent().addStatement("$T.builder().build().printErrorMessage($N)", StandardErrorHandler.class, notSuccess).addStatement("$T.exit(1)", System.class).addStatement("return new $T()", RuntimeException.class).unindent().addStatement("})", new Object[0]).unindent();
        return MethodSpec.methodBuilder("parseOrExit").addParameter(args).addModifiers(this.sourceElement.accessModifiers()).returns(this.generatedTypes.parseSuccessType()).addCode(code.build()).build();
    }
}

