/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.context;

import java.util.List;
import javax.lang.model.element.Modifier;
import net.jbock.annotated.AnnotatedOption;
import net.jbock.context.CommonFields;
import net.jbock.context.ContextScope;
import net.jbock.context.CreateModelMethod;
import net.jbock.context.GeneratedAnnotation;
import net.jbock.context.HarvestMethod;
import net.jbock.context.OptEnum;
import net.jbock.context.OptionNamesMethod;
import net.jbock.context.OptionStatesMethod;
import net.jbock.context.ParseMethod;
import net.jbock.context.ParseOrExitMethod;
import net.jbock.convert.Mapping;
import net.jbock.javapoet.MethodSpec;
import net.jbock.javapoet.TypeSpec;
import net.jbock.javax.inject.Inject;
import net.jbock.processor.SourceElement;

@ContextScope
public final class ParserClass {
    private final ParseMethod parseMethod;
    private final OptEnum optionEnum;
    private final SourceElement sourceElement;
    private final List<Mapping<AnnotatedOption>> namedOptions;
    private final ParseOrExitMethod parseOrExitMethod;
    private final CreateModelMethod createModelMethod;
    private final GeneratedAnnotation generatedAnnotation;
    private final HarvestMethod harvestMethod;
    private final OptionNamesMethod optionNamesMethod;
    private final OptionStatesMethod optionStatesMethod;
    private final CommonFields commonFields;

    @Inject
    ParserClass(ParseMethod parseMethod, SourceElement sourceElement, OptEnum optionEnum, List<Mapping<AnnotatedOption>> namedOptions, ParseOrExitMethod parseOrExitMethod, CreateModelMethod createModelMethod, GeneratedAnnotation generatedAnnotation, HarvestMethod harvestMethod, OptionNamesMethod optionNamesMethod, OptionStatesMethod optionStatesMethod, CommonFields commonFields) {
        this.parseMethod = parseMethod;
        this.sourceElement = sourceElement;
        this.optionEnum = optionEnum;
        this.namedOptions = namedOptions;
        this.parseOrExitMethod = parseOrExitMethod;
        this.createModelMethod = createModelMethod;
        this.generatedAnnotation = generatedAnnotation;
        this.harvestMethod = harvestMethod;
        this.optionNamesMethod = optionNamesMethod;
        this.optionStatesMethod = optionStatesMethod;
        this.commonFields = commonFields;
    }

    public TypeSpec define() {
        TypeSpec.Builder spec = TypeSpec.classBuilder(this.sourceElement.generatedClass());
        spec.addMethod((MethodSpec)this.parseMethod.get());
        if (!this.sourceElement.skipGeneratingParseOrExitMethod()) {
            spec.addMethod(this.parseOrExitMethod.define());
        }
        spec.addMethod((MethodSpec)this.harvestMethod.get());
        if (!this.namedOptions.isEmpty()) {
            spec.addField(this.commonFields.optionNames().toBuilder().initializer("$N()", this.optionNamesMethod.get()).build());
            spec.addMethod((MethodSpec)this.optionNamesMethod.get());
            spec.addMethod((MethodSpec)this.optionStatesMethod.get());
            spec.addType(this.optionEnum.define());
        }
        spec.addMethod((MethodSpec)this.createModelMethod.get());
        return spec.addOriginatingElement(this.sourceElement.element()).addModifiers(this.sourceElement.accessModifiers().toArray(new Modifier[0])).addModifiers(Modifier.FINAL).addAnnotation(this.generatedAnnotation.define()).build();
    }
}

