/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.convert;

import java.util.Optional;
import java.util.function.Function;
import net.jbock.annotated.AnnotatedMethod;
import net.jbock.common.EnumName;
import net.jbock.convert.match.Match;
import net.jbock.javapoet.CodeBlock;
import net.jbock.model.Multiplicity;
import net.jbock.util.StringConverter;

public final class Mapping<M extends AnnotatedMethod> {
    private final CodeBlock mapper;
    private final Match<M> match;
    private final boolean modeFlag;

    private Mapping(CodeBlock mapper, Match<M> match, boolean modeFlag) {
        this.mapper = mapper;
        this.match = match;
        this.modeFlag = modeFlag;
    }

    public static <M extends AnnotatedMethod> Mapping<M> create(CodeBlock mapper, Match<M> match) {
        return new Mapping<M>(mapper, match, false);
    }

    public static <M extends AnnotatedMethod> Mapping<M> createModeFlag(Match<M> match) {
        CodeBlock mapper = CodeBlock.of("$T.create($T.identity())", StringConverter.class, Function.class);
        return new Mapping<M>(mapper, match, true);
    }

    public CodeBlock mapper() {
        return this.mapper;
    }

    public Optional<CodeBlock> extractExpr() {
        return this.match.extractExpr();
    }

    public Multiplicity multiplicity() {
        return this.match.multiplicity();
    }

    public EnumName enumName() {
        return ((AnnotatedMethod)this.sourceMethod()).enumName();
    }

    public boolean isRequired() {
        return this.multiplicity() == Multiplicity.REQUIRED;
    }

    public boolean isRepeatable() {
        return this.multiplicity() == Multiplicity.REPEATABLE;
    }

    public boolean isOptional() {
        return this.multiplicity() == Multiplicity.OPTIONAL;
    }

    public boolean isModeFlag() {
        return this.modeFlag;
    }

    public M sourceMethod() {
        return this.match.sourceMethod();
    }

    public String paramLabel() {
        return ((AnnotatedMethod)this.sourceMethod()).paramLabel();
    }
}

