/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.convert;

import io.jbock.util.Either;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import net.jbock.annotated.AnnotatedMethod;
import net.jbock.common.Util;
import net.jbock.common.ValidationFailure;
import net.jbock.convert.Mapping;
import net.jbock.convert.map.AutoOrEnumMapper;
import net.jbock.convert.map.ConverterMapper;
import net.jbock.convert.match.Match;
import net.jbock.convert.match.MatchFinder;
import net.jbock.dagger.Lazy;
import net.jbock.javax.inject.Inject;
import net.jbock.processor.SourceElement;
import net.jbock.validate.ValidateScope;

@ValidateScope
public class MappingFinder {
    private final Lazy<AutoOrEnumMapper> autoOrEnumMapper;
    private final Lazy<ConverterMapper> converterValidator;
    private final SourceElement sourceElement;
    private final Util util;
    private final MatchFinder matchFinder;

    @Inject
    MappingFinder(Lazy<AutoOrEnumMapper> autoOrEnumMapper, Lazy<ConverterMapper> converterValidator, SourceElement sourceElement, Util util, MatchFinder matchFinder) {
        this.autoOrEnumMapper = autoOrEnumMapper;
        this.converterValidator = converterValidator;
        this.sourceElement = sourceElement;
        this.util = util;
        this.matchFinder = matchFinder;
    }

    public <M extends AnnotatedMethod> Either<ValidationFailure, Mapping<M>> findMapping(M sourceMethod) {
        return this.matchFinder.findMatch(sourceMethod).flatMap(this::findMappingWithMatch);
    }

    private <M extends AnnotatedMethod> Either<ValidationFailure, Mapping<M>> findMappingWithMatch(Match<M> match) {
        Object sourceMethod = match.sourceMethod();
        return ((AnnotatedMethod)sourceMethod).converter().map(converter -> this.checkConverterIsInnerClass(sourceMethod, (TypeElement)converter).or(() -> this.util.commonTypeChecks((TypeElement)converter)).or(() -> this.checkNotAbstract(sourceMethod, (TypeElement)converter)).or(() -> this.checkNoTypeVars(sourceMethod, (TypeElement)converter)).or(() -> this.checkConverterIsInnerClass(sourceMethod, (TypeElement)converter)).map(failure -> failure.prepend("invalid converter class: ")).map(Either::left).orElseGet(() -> Either.right((Object)converter)).flatMap(c -> this.converterValidator.get().findMapping(match, (TypeElement)c))).orElseGet(() -> this.autoOrEnumMapper.get().findMapping(match));
    }

    private <M extends AnnotatedMethod> Optional<ValidationFailure> checkConverterIsInnerClass(M sourceMethod, TypeElement converter) {
        boolean nestedMapper = this.util.getEnclosingElements(converter).contains(this.sourceElement.element());
        if (!nestedMapper) {
            return Optional.of(sourceMethod.fail("converter of '" + sourceMethod.methodName() + "' must be an inner class of the command class '" + this.sourceElement.element().getSimpleName() + "'"));
        }
        return Optional.empty();
    }

    private <M extends AnnotatedMethod> Optional<ValidationFailure> checkNotAbstract(M sourceMethod, TypeElement converter) {
        if (converter.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return Optional.of(sourceMethod.fail("the converter class '" + converter.getSimpleName() + "' may not be abstract"));
        }
        return Optional.empty();
    }

    private <M extends AnnotatedMethod> Optional<ValidationFailure> checkNoTypeVars(M sourceMethod, TypeElement converter) {
        if (!converter.getTypeParameters().isEmpty()) {
            return Optional.of(sourceMethod.fail("type parameters are not allowed in the declaration of converter class '" + converter.getSimpleName() + "'"));
        }
        return Optional.empty();
    }
}

