/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.convert.map;

import io.jbock.util.Either;
import java.util.Optional;
import java.util.function.Supplier;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import net.jbock.annotated.AnnotatedMethod;
import net.jbock.common.SafeElements;
import net.jbock.common.SafeTypes;
import net.jbock.common.TypeTool;
import net.jbock.common.Util;
import net.jbock.common.ValidationFailure;
import net.jbock.convert.Mapping;
import net.jbock.convert.map.ConverterType;
import net.jbock.convert.match.Match;
import net.jbock.javax.inject.Inject;
import net.jbock.util.StringConverter;
import net.jbock.validate.ValidateScope;

@ValidateScope
public class ConverterMapper {
    private final SafeTypes types;
    private final SafeElements elements;
    private final Util util;

    @Inject
    ConverterMapper(SafeTypes types, SafeElements elements, Util util) {
        this.types = types;
        this.elements = elements;
        this.util = util;
    }

    public <M extends AnnotatedMethod> Either<ValidationFailure, Mapping<M>> findMapping(Match<M> match, TypeElement converter) {
        return this.getConverterType(match, converter).map(ConverterType::toMapping);
    }

    private <M extends AnnotatedMethod> Either<ValidationFailure, ConverterType<M>> getConverterType(Match<M> match, TypeElement converter) {
        return this.checkSupplier(converter).map(declaredType -> this.handleSupplier(converter, match, (DeclaredType)declaredType)).or(() -> this.checkStringConverter(converter).map(stringConverterType -> this.handleStringConverter(converter, match, (DeclaredType)stringConverterType, false))).orElseGet(() -> Either.left((Object)match.fail(this.errorConverterType()))).filter(referencedType -> referencedType.checkMatchingMatch(this.util));
    }

    private <M extends AnnotatedMethod> Either<ValidationFailure, ConverterType<M>> handleSupplier(TypeElement converter, Match<M> match, DeclaredType declaredType) {
        if (declaredType.getTypeArguments().size() != 1) {
            return Either.left((Object)match.fail(this.converterRawType(declaredType)));
        }
        TypeMirror typeArgument = declaredType.getTypeArguments().get(0);
        return TypeTool.AS_DECLARED.visit(typeArgument).filter(suppliedFunction -> this.isSameErasure((TypeMirror)suppliedFunction, StringConverter.class)).map(Either::right).orElseGet(() -> Either.left((Object)match.fail(this.errorConverterType()))).flatMap(suppliedType -> this.handleStringConverter(converter, match, (DeclaredType)suppliedType, true));
    }

    private <M extends AnnotatedMethod> Either<ValidationFailure, ConverterType<M>> handleStringConverter(TypeElement converter, Match<M> match, DeclaredType declaredType, boolean isSupplier) {
        if (declaredType.getTypeArguments().size() != 1) {
            return Either.left((Object)match.fail(this.converterRawType(declaredType)));
        }
        TypeMirror typeArgument = declaredType.getTypeArguments().get(0);
        return Either.right(new ConverterType<M>(converter, match, typeArgument, isSupplier));
    }

    private Optional<DeclaredType> checkSupplier(TypeElement converter) {
        return converter.getInterfaces().stream().filter(inter -> this.isSameErasure((TypeMirror)inter, Supplier.class)).map(TypeTool.AS_DECLARED::visit).flatMap(Optional::stream).findFirst();
    }

    private Optional<DeclaredType> checkStringConverter(TypeElement converter) {
        return Optional.of(converter.getSuperclass()).filter(inter -> this.isSameErasure((TypeMirror)inter, StringConverter.class)).flatMap(TypeTool.AS_DECLARED::visit);
    }

    private boolean isSameErasure(TypeMirror x, Class<?> y) {
        return this.elements.getTypeElement(y.getCanonicalName()).map(Element::asType).map(type -> this.types.isSameType(this.types.erasure(x), this.types.erasure((TypeMirror)type))).orElse(false);
    }

    private String errorConverterType() {
        return "invalid converter class: converter must extend " + StringConverter.class.getSimpleName() + "<X> or implement " + Supplier.class.getSimpleName() + "<" + StringConverter.class.getSimpleName() + "<X>>";
    }

    private String converterRawType(DeclaredType declaredType) {
        return "invalid converter class: missing a type parameter in type '" + declaredType.asElement().getSimpleName() + "'";
    }
}

