/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.convert.map;

import java.util.Optional;
import java.util.function.Supplier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import net.jbock.annotated.AnnotatedMethod;
import net.jbock.common.Util;
import net.jbock.common.ValidationFailure;
import net.jbock.convert.Mapping;
import net.jbock.convert.match.Match;
import net.jbock.javapoet.CodeBlock;
import net.jbock.util.StringConverter;

public final class ConverterType<M extends AnnotatedMethod> {
    private final TypeElement converter;
    private final Match<M> match;
    private final TypeMirror outputType;
    private final boolean supplier;

    ConverterType(TypeElement converter, Match<M> match, TypeMirror outputType, boolean supplier) {
        this.converter = converter;
        this.match = match;
        this.outputType = outputType;
        this.supplier = supplier;
    }

    Optional<ValidationFailure> checkMatchingMatch(Util util) {
        if (!util.types().isSameType(this.outputType, this.match.baseType())) {
            String expectedType = StringConverter.class.getSimpleName() + "<" + util.typeToString(this.match.baseType()) + ">";
            return Optional.of(this.match.fail("invalid converter class: should extend " + expectedType + " or implement " + Supplier.class.getSimpleName() + "<" + expectedType + ">"));
        }
        return Optional.empty();
    }

    private CodeBlock asMapper() {
        TypeMirror type = this.converter.asType();
        if (this.supplier) {
            return CodeBlock.of("new $T().get()", type);
        }
        return CodeBlock.of("new $T()", type);
    }

    Mapping<M> toMapping() {
        return Mapping.create(this.asMapper(), this.match);
    }
}

