/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.convert.match;

import java.util.Optional;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import net.jbock.annotated.AnnotatedMethod;
import net.jbock.common.SafeElements;
import net.jbock.common.TypeTool;
import net.jbock.convert.match.Match;
import net.jbock.convert.match.Matcher;
import net.jbock.javax.inject.Inject;
import net.jbock.model.Multiplicity;
import net.jbock.validate.ValidateScope;

@ValidateScope
public class ListMatcher
implements Matcher {
    private final SafeElements elements;
    private final TypeTool tool;

    @Inject
    ListMatcher(SafeElements elements, TypeTool tool) {
        this.elements = elements;
        this.tool = tool;
    }

    @Override
    public <M extends AnnotatedMethod> Optional<Match<M>> tryMatch(M sourceMethod) {
        TypeMirror returnType = sourceMethod.returnType();
        return this.elements.getTypeElement("java.util.List").flatMap(utilList -> this.tool.getSingleTypeArgument(returnType, (TypeElement)utilList)).map(typeArg -> Match.create(typeArg, Multiplicity.REPEATABLE, sourceMethod));
    }
}

