/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.convert.match;

import java.util.Optional;
import javax.lang.model.type.TypeMirror;
import net.jbock.annotated.AnnotatedMethod;
import net.jbock.common.ValidationFailure;
import net.jbock.javapoet.CodeBlock;
import net.jbock.model.Multiplicity;

public final class Match<M extends AnnotatedMethod> {
    private final TypeMirror baseType;
    private final Optional<CodeBlock> extractExpr;
    private final Multiplicity multiplicity;
    private final M sourceMethod;

    private Match(TypeMirror baseType, Multiplicity multiplicity, Optional<CodeBlock> extractExpr, M sourceMethod) {
        this.baseType = baseType;
        this.multiplicity = multiplicity;
        this.extractExpr = extractExpr;
        this.sourceMethod = sourceMethod;
    }

    static <M extends AnnotatedMethod> Match<M> createWithExtract(TypeMirror baseType, CodeBlock extractExpr, M sourceMethod) {
        return new Match<M>(baseType, Multiplicity.OPTIONAL, Optional.of(extractExpr), sourceMethod);
    }

    static <M extends AnnotatedMethod> Match<M> create(TypeMirror baseType, Multiplicity multiplicity, M sourceMethod) {
        return new Match<M>(baseType, multiplicity, Optional.empty(), sourceMethod);
    }

    public TypeMirror baseType() {
        return this.baseType;
    }

    public Multiplicity multiplicity() {
        return this.multiplicity;
    }

    public M sourceMethod() {
        return this.sourceMethod;
    }

    public ValidationFailure fail(String message) {
        return ((AnnotatedMethod)this.sourceMethod()).fail(message);
    }

    public Optional<CodeBlock> extractExpr() {
        return this.extractExpr;
    }
}

