/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.convert.match;

import io.jbock.util.Either;
import java.util.Optional;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import net.jbock.Option;
import net.jbock.Parameters;
import net.jbock.annotated.AnnotatedMethod;
import net.jbock.common.SafeTypes;
import net.jbock.common.TypeTool;
import net.jbock.common.ValidationFailure;
import net.jbock.convert.match.ListMatcher;
import net.jbock.convert.match.Match;
import net.jbock.convert.match.OptionalMatcher;
import net.jbock.javax.inject.Inject;
import net.jbock.model.Multiplicity;
import net.jbock.validate.ValidateScope;

@ValidateScope
public class MatchFinder {
    private final OptionalMatcher optionalMatcher;
    private final ListMatcher listMatcher;
    private final SafeTypes types;

    @Inject
    MatchFinder(OptionalMatcher optionalMatcher, ListMatcher listMatcher, SafeTypes types) {
        this.optionalMatcher = optionalMatcher;
        this.listMatcher = listMatcher;
        this.types = types;
    }

    public <M extends AnnotatedMethod> Either<ValidationFailure, Match<M>> findMatch(M sourceMethod) {
        Match match = this.findMatchInternal(sourceMethod);
        return this.validateParameterVsParameters(match).map(Either::left).orElseGet(() -> Either.right((Object)match));
    }

    public <M extends AnnotatedMethod> Either<ValidationFailure, Match<M>> validateModeFlag(M sourceMethod) {
        PrimitiveType bool = this.types.getPrimitiveType(TypeKind.BOOLEAN);
        Match match = Match.create(bool, Multiplicity.OPTIONAL, sourceMethod);
        return this.validateParameterVsParameters(match).map(Either::left).orElseGet(() -> Either.right((Object)match));
    }

    private <M extends AnnotatedMethod> Match<M> findMatchInternal(M sourceMethod) {
        return Stream.of(this.optionalMatcher, this.listMatcher).map(matcher -> matcher.tryMatch(sourceMethod)).flatMap(Optional::stream).findFirst().orElseGet(() -> {
            TypeMirror baseType = TypeTool.AS_PRIMITIVE.visit(sourceMethod.returnType()).map(this.types::boxedClass).map(Element::asType).orElse(sourceMethod.returnType());
            return Match.create(baseType, Multiplicity.REQUIRED, sourceMethod);
        });
    }

    private <M extends AnnotatedMethod> Optional<ValidationFailure> validateParameterVsParameters(Match<M> match) {
        M sourceMethod = match.sourceMethod();
        if (((AnnotatedMethod)sourceMethod).isParameter() && match.multiplicity() == Multiplicity.REPEATABLE) {
            return Optional.of(((AnnotatedMethod)sourceMethod).fail("method '" + ((AnnotatedMethod)sourceMethod).method().getSimpleName() + "' returns a list-based type, so it must be annotated with @" + Option.class.getSimpleName() + " or @" + Parameters.class.getSimpleName()));
        }
        if (((AnnotatedMethod)sourceMethod).isParameters() && match.multiplicity() != Multiplicity.REPEATABLE) {
            return Optional.of(((AnnotatedMethod)sourceMethod).fail("method '" + ((AnnotatedMethod)sourceMethod).method().getSimpleName() + "' is annotated with @" + Parameters.class.getSimpleName() + ", so it must return java.util.List"));
        }
        return Optional.empty();
    }
}

