/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.convert.match;

import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import net.jbock.annotated.AnnotatedMethod;
import net.jbock.common.SafeElements;
import net.jbock.common.SafeTypes;
import net.jbock.common.TypeTool;
import net.jbock.convert.match.Match;
import net.jbock.convert.match.Matcher;
import net.jbock.convert.match.OptionalPrimitive;
import net.jbock.javapoet.CodeBlock;
import net.jbock.javax.inject.Inject;
import net.jbock.model.Multiplicity;
import net.jbock.validate.ValidateScope;

@ValidateScope
public class OptionalMatcher
implements Matcher {
    private final TypeTool tool;
    private final SafeElements elements;
    private final SafeTypes types;

    @Inject
    OptionalMatcher(TypeTool tool, SafeElements elements, SafeTypes types) {
        this.tool = tool;
        this.elements = elements;
        this.types = types;
    }

    @Override
    public <M extends AnnotatedMethod> Optional<Match<M>> tryMatch(M sourceMethod) {
        TypeMirror returnType = sourceMethod.returnType();
        return this.getOptionalPrimitive(sourceMethod, returnType).or(() -> this.matchOptional(sourceMethod, returnType)).or(() -> this.matchVavr(sourceMethod, returnType));
    }

    private <M extends AnnotatedMethod> Optional<Match<M>> matchOptional(M sourceMethod, TypeMirror returnType) {
        return this.elements.getTypeElement("java.util.Optional").flatMap(el -> this.tool.getSingleTypeArgument(returnType, (TypeElement)el)).map(typeArg -> Match.create(typeArg, Multiplicity.OPTIONAL, sourceMethod));
    }

    private <M extends AnnotatedMethod> Optional<Match<M>> matchVavr(M sourceMethod, TypeMirror returnType) {
        return this.elements.getTypeElement("io.vavr.control.Option").flatMap(el -> this.tool.getSingleTypeArgument(returnType, (TypeElement)el).map(typeArg -> Match.createWithExtract(typeArg, CodeBlock.of(".map($1T::of).orElse($1T.none())", this.types.erasure(el.asType())), sourceMethod)));
    }

    private <M extends AnnotatedMethod> Optional<Match<M>> getOptionalPrimitive(M sourceMethod, TypeMirror type) {
        for (OptionalPrimitive optionalPrimitive : OptionalPrimitive.values()) {
            if (!this.tool.isSameType(type, optionalPrimitive.type())) continue;
            CodeBlock extractExpr = optionalPrimitive.extractExpr();
            return this.elements.getTypeElement(optionalPrimitive.numberType()).map(Element::asType).map(numberType -> Match.createWithExtract(numberType, extractExpr, sourceMethod));
        }
        return Optional.empty();
    }
}

