/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.processor;

import io.jbock.util.Either;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import net.jbock.Command;
import net.jbock.common.SafeElements;
import net.jbock.common.SafeTypes;
import net.jbock.common.Util;
import net.jbock.common.ValidationFailure;
import net.jbock.context.ContextModule;
import net.jbock.context.DaggerContextComponent;
import net.jbock.google.auto.common.BasicAnnotationProcessor;
import net.jbock.google.common.base.Preconditions;
import net.jbock.google.common.collect.ImmutableSetMultimap;
import net.jbock.javapoet.JavaFile;
import net.jbock.javapoet.TypeSpec;
import net.jbock.javax.inject.Inject;
import net.jbock.processor.ProcessorScope;
import net.jbock.processor.SourceElement;
import net.jbock.processor.SourceFileGenerator;
import net.jbock.validate.CommandProcessor;
import net.jbock.validate.DaggerValidateComponent;
import net.jbock.validate.ValidateModule;

@ProcessorScope
public class CommandStep
implements BasicAnnotationProcessor.Step {
    private final Messager messager;
    private final Util util;
    private final SafeTypes types;
    private final SafeElements elements;
    private final SourceFileGenerator sourceFileGenerator;

    @Inject
    CommandStep(Messager messager, Util util, SafeTypes types, SafeElements elements, SourceFileGenerator sourceFileGenerator) {
        this.messager = messager;
        this.util = util;
        this.types = types;
        this.elements = elements;
        this.sourceFileGenerator = sourceFileGenerator;
    }

    @Override
    public Set<String> annotations() {
        return Set.of(Command.class.getCanonicalName());
    }

    @Override
    public Set<? extends Element> process(ImmutableSetMultimap<String, Element> elementsByAnnotation) {
        elementsByAnnotation.forEach((annotationName, element) -> ElementFilter.typesIn(List.of(element)).stream().map(this::validateSourceElement).forEach(either -> either.ifLeftOrElse(this::printFailures, this::processSourceElement)));
        return Set.of();
    }

    private void processSourceElement(SourceElement sourceElement) {
        CommandProcessor processor = DaggerValidateComponent.builder().sourceElement(sourceElement).module(new ValidateModule(this.types, this.elements)).create().processor();
        processor.generate().map(items -> items.contextModule(sourceElement)).map(module -> DaggerContextComponent.factory().create((ContextModule)module)).ifLeftOrElse(this::printFailures, component -> this.writeSpecs(sourceElement, List.of(component.parserClass().define(), component.implClass().define())));
    }

    private void writeSpecs(SourceElement sourceElement, List<TypeSpec> typeSpecs) {
        typeSpecs.forEach(typeSpec -> this.writeSpec(sourceElement, (TypeSpec)typeSpec));
    }

    private void writeSpec(SourceElement sourceElement, TypeSpec typeSpec) {
        Preconditions.checkArgument(typeSpec.originatingElements.size() == 1);
        String packageName = sourceElement.generatedClass().packageName();
        JavaFile javaFile = JavaFile.builder(packageName, typeSpec).skipJavaLangImports(true).build();
        this.sourceFileGenerator.write(sourceElement, javaFile);
    }

    private Either<List<ValidationFailure>, SourceElement> validateSourceElement(TypeElement element) {
        return this.util.commonTypeChecks(element).map(List::of).map(Either::left).orElseGet(() -> Either.right((Object)SourceElement.create(element)));
    }

    private void printFailures(List<ValidationFailure> failures) {
        for (ValidationFailure failure : failures) {
            failure.writeTo(this.messager);
        }
    }
}

