/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.processor;

import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import net.jbock.common.SafeElements;
import net.jbock.common.SafeTypes;
import net.jbock.common.TypeTool;
import net.jbock.common.Util;
import net.jbock.dagger.Module;
import net.jbock.dagger.Provides;
import net.jbock.processor.ProcessorScope;

@Module
public class ProcessorModule {
    private final ProcessingEnvironment processingEnvironment;

    ProcessorModule(ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
    }

    @ProcessorScope
    @Provides
    Messager messager() {
        return this.processingEnvironment.getMessager();
    }

    @ProcessorScope
    @Provides
    Filer filer() {
        return this.processingEnvironment.getFiler();
    }

    @ProcessorScope
    @Provides
    SafeElements elements() {
        return new SafeElements(this.processingEnvironment.getElementUtils());
    }

    @ProcessorScope
    @Provides
    SafeTypes types() {
        return new SafeTypes(this.processingEnvironment.getTypeUtils());
    }

    @ProcessorScope
    @Provides
    TypeTool tool(SafeElements elements, SafeTypes types) {
        return new TypeTool(elements, types);
    }

    @ProcessorScope
    @Provides
    Util util(SafeTypes types, TypeTool tool) {
        return new Util(types, tool);
    }
}

