/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.processor;

import java.util.List;
import java.util.Optional;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import net.jbock.Command;
import net.jbock.common.Constants;
import net.jbock.common.SnakeName;
import net.jbock.common.ValidationFailure;
import net.jbock.javapoet.ClassName;
import net.jbock.javapoet.TypeName;

public class SourceElement {
    private final TypeElement sourceElement;
    private final List<Modifier> accessModifiers;
    private final String programName;
    private final ClassName generatedClass;
    private final ClassName optionEnumType;
    private final Command command;

    private SourceElement(TypeElement sourceElement, List<Modifier> accessModifiers, String programName, ClassName generatedClass, ClassName optionEnumType, Command command) {
        this.sourceElement = sourceElement;
        this.accessModifiers = accessModifiers;
        this.programName = programName;
        this.generatedClass = generatedClass;
        this.optionEnumType = optionEnumType;
        this.command = command;
    }

    static SourceElement create(TypeElement typeElement) {
        Command command = typeElement.getAnnotation(Command.class);
        List<Modifier> accessModifiers = command.publicParser() ? List.of(Modifier.PUBLIC) : List.of();
        String programName = Constants.optionalString(command.name()).orElseGet(() -> SnakeName.create(typeElement.getSimpleName().toString()).snake('-'));
        String generatedClassName = String.join((CharSequence)"_", ClassName.get(typeElement).simpleNames()) + "Parser";
        ClassName generatedClass = ClassName.get(typeElement).topLevelClassName().peerClass(generatedClassName);
        ClassName optionEnumType = generatedClass.nestedClass("Opt");
        return new SourceElement(typeElement, accessModifiers, programName, generatedClass, optionEnumType, command);
    }

    public TypeElement element() {
        return this.sourceElement;
    }

    public TypeName typeName() {
        return TypeName.get(this.sourceElement.asType());
    }

    public ValidationFailure fail(String message) {
        return new ValidationFailure(message, this.sourceElement);
    }

    public boolean isSuperCommand() {
        return this.command.superCommand();
    }

    public List<Modifier> accessModifiers() {
        return this.accessModifiers;
    }

    public ClassName generatedClass() {
        return this.generatedClass;
    }

    public ClassName optionEnumType() {
        return this.optionEnumType;
    }

    public boolean isInterface() {
        return this.sourceElement.getKind() == ElementKind.INTERFACE;
    }

    public String programName() {
        return this.programName;
    }

    public Optional<String> descriptionKey() {
        return Constants.optionalString(this.command.descriptionKey());
    }

    public List<String> description() {
        return List.of(this.command.description());
    }

    public boolean skipGeneratingParseOrExitMethod() {
        return this.command.skipGeneratingParseOrExitMethod();
    }
}

