/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.processor;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.tools.Diagnostic;
import net.jbock.javapoet.JavaFile;
import net.jbock.javax.inject.Inject;
import net.jbock.processor.ProcessorScope;
import net.jbock.processor.SourceElement;

@ProcessorScope
public class SourceFileGenerator {
    private final Filer filer;
    private final Messager messager;

    @Inject
    SourceFileGenerator(Filer filer, Messager messager) {
        this.filer = filer;
        this.messager = messager;
    }

    void write(SourceElement sourceElement, JavaFile javaFile) {
        try {
            javaFile.writeTo(this.filer);
        }
        catch (IOException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String stack = sw.toString();
            this.messager.printMessage(Diagnostic.Kind.ERROR, stack, sourceElement.element());
        }
    }
}

