/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.validate;

import io.jbock.util.Either;
import io.jbock.util.Eithers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.jbock.annotated.AnnotatedMethods;
import net.jbock.annotated.AnnotatedMethodsFactory;
import net.jbock.common.ValidationFailure;
import net.jbock.javax.inject.Inject;
import net.jbock.processor.SourceElement;
import net.jbock.validate.ContextBuilder;
import net.jbock.validate.SourceOptionValidator;
import net.jbock.validate.SourceParameterValidator;
import net.jbock.validate.SourceParametersValidator;
import net.jbock.validate.ValidateScope;

@ValidateScope
public class CommandProcessor {
    private final AnnotatedMethodsFactory methodsFactory;
    private final SourceElement sourceElement;
    private final SourceOptionValidator optionValidator;
    private final SourceParameterValidator parameterValidator;
    private final SourceParametersValidator parametersValidator;

    @Inject
    CommandProcessor(AnnotatedMethodsFactory methodsFactory, SourceElement sourceElement, SourceOptionValidator optionValidator, SourceParameterValidator parameterValidator, SourceParametersValidator parametersValidator) {
        this.methodsFactory = methodsFactory;
        this.sourceElement = sourceElement;
        this.optionValidator = optionValidator;
        this.parameterValidator = parameterValidator;
        this.parametersValidator = parametersValidator;
    }

    public Either<List<ValidationFailure>, ContextBuilder> generate() {
        return this.methodsFactory.createAnnotatedMethods().filter(this::checkDuplicateDescriptionKeys).map(ContextBuilder::builder).flatMap(this.parameterValidator::wrapPositionalParams).flatMap(this.parametersValidator::wrapRepeatablePositionalParams).flatMap(this.optionValidator::wrapOptions);
    }

    private Optional<List<ValidationFailure>> checkDuplicateDescriptionKeys(AnnotatedMethods methods) {
        ArrayList failures = new ArrayList();
        HashSet keys = new HashSet();
        this.sourceElement.descriptionKey().ifPresent(keys::add);
        Stream.of(methods.namedOptions(), methods.positionalParameters(), methods.repeatablePositionalParameters()).flatMap(Collection::stream).forEach(m -> m.descriptionKey().ifPresent(key -> {
            if (!keys.add(key)) {
                String message = "duplicate description key: " + key;
                failures.add(m.fail(message));
            }
        }));
        return Eithers.optionalList(failures);
    }
}

