/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.validate;

import io.jbock.util.Either;
import io.jbock.util.Eithers;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.type.TypeKind;
import net.jbock.annotated.AnnotatedOption;
import net.jbock.common.ValidationFailure;
import net.jbock.convert.Mapping;
import net.jbock.convert.MappingFinder;
import net.jbock.convert.match.MatchFinder;
import net.jbock.javax.inject.Inject;
import net.jbock.validate.ContextBuilder;
import net.jbock.validate.ValidateScope;

@ValidateScope
public class SourceOptionValidator {
    private final MappingFinder mappingFinder;
    private final MatchFinder matchFinder;

    @Inject
    SourceOptionValidator(MappingFinder mappingFinder, MatchFinder matchFinder) {
        this.mappingFinder = mappingFinder;
        this.matchFinder = matchFinder;
    }

    Either<List<ValidationFailure>, ContextBuilder> wrapOptions(ContextBuilder.Step3 step) {
        return ((Either)step.namedOptions().stream().map(this::checkOptionNames).collect(Eithers.toValidListAll())).filter(this::validateUniqueOptionNames).flatMap(sourceOptions -> (Either)sourceOptions.stream().map(this::wrapOption).collect(Eithers.toValidListAll())).map(step::accept);
    }

    private Either<ValidationFailure, Mapping<AnnotatedOption>> wrapOption(AnnotatedOption option) {
        return this.checkFlag(option).map(m -> this.matchFinder.validateModeFlag(m).map(Mapping::createModeFlag)).orElseGet(() -> this.mappingFinder.findMapping(option));
    }

    private Optional<AnnotatedOption> checkFlag(AnnotatedOption option) {
        if (option.converter().isPresent()) {
            return Optional.empty();
        }
        if (option.returnType().getKind() != TypeKind.BOOLEAN) {
            return Optional.empty();
        }
        return Optional.of(option);
    }

    private Either<ValidationFailure, AnnotatedOption> checkOptionNames(AnnotatedOption option) {
        if (option.names().isEmpty()) {
            return Either.left((Object)option.fail("define at least one option name"));
        }
        return option.names().stream().map(name -> this.checkName(option, (String)name)).flatMap(Optional::stream).map(s -> s.prepend("invalid name: ")).findFirst().map(Either::left).orElseGet(() -> Either.right((Object)option));
    }

    private Optional<ValidationFailure> checkName(AnnotatedOption option, String name) {
        if (Objects.toString(name, "").length() <= 1 || "--".equals(name)) {
            return Optional.of(option.fail(name));
        }
        if (!name.startsWith("-")) {
            return Optional.of(option.fail("must start with a dash character: " + name));
        }
        if (name.startsWith("---")) {
            return Optional.of(option.fail("cannot start with three dashes: " + name));
        }
        if (!name.startsWith("--") && name.length() > 2) {
            return Optional.of(option.fail("single-dash name must be single-character: " + name));
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isWhitespace(c)) {
                return Optional.of(option.fail("whitespace characters: " + name));
            }
            if (c != '=') continue;
            return Optional.of(option.fail("invalid character '=': " + name));
        }
        return Optional.empty();
    }

    private Optional<List<ValidationFailure>> validateUniqueOptionNames(List<AnnotatedOption> allOptions) {
        HashSet allNames = new HashSet();
        return (Optional)allOptions.stream().flatMap(option -> option.names().stream().filter(name -> !allNames.add(name)).map(name -> "duplicate option name: " + name).map(option::fail)).collect(Eithers.toOptionalList());
    }
}

