/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.validate;

import io.jbock.util.Either;
import io.jbock.util.Eithers;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.jbock.annotated.AnnotatedParameter;
import net.jbock.common.ValidationFailure;
import net.jbock.convert.Mapping;
import net.jbock.convert.MappingFinder;
import net.jbock.javax.inject.Inject;
import net.jbock.validate.ContextBuilder;
import net.jbock.validate.ValidateScope;

@ValidateScope
public class SourceParameterValidator {
    private final MappingFinder mappingFinder;

    @Inject
    SourceParameterValidator(MappingFinder mappingFinder) {
        this.mappingFinder = mappingFinder;
    }

    Either<List<ValidationFailure>, ContextBuilder.Step2> wrapPositionalParams(ContextBuilder.Step1 step) {
        return this.validatePositions(step.positionalParameters()).flatMap(positionalParameters -> (Either)positionalParameters.stream().map(this.mappingFinder::findMapping).collect(Eithers.toValidListAll())).filter(this::checkNoRequiredAfterOptional).map(step::accept);
    }

    private Either<List<ValidationFailure>, List<AnnotatedParameter>> validatePositions(List<AnnotatedParameter> positionalParameters) {
        ArrayList<ValidationFailure> failures = new ArrayList<ValidationFailure>();
        for (int i = 0; i < positionalParameters.size(); ++i) {
            AnnotatedParameter sourceParameter = positionalParameters.get(i);
            int index = sourceParameter.index();
            if (index == i) continue;
            failures.add(sourceParameter.fail("invalid position: expecting " + i + " but found " + index));
        }
        return Eithers.optionalList(failures).map(Either::left).orElseGet(() -> Either.right((Object)positionalParameters));
    }

    private Optional<List<ValidationFailure>> checkNoRequiredAfterOptional(List<Mapping<AnnotatedParameter>> positionalParameters) {
        return positionalParameters.stream().filter(Mapping::isOptional).findFirst().map(Mapping::sourceMethod).flatMap(firstOptional -> (Optional)positionalParameters.stream().filter(Mapping::isRequired).map(Mapping::sourceMethod).filter(sourceMethod -> sourceMethod.index() > firstOptional.index()).map(item -> item.fail("position of required parameter '" + item.method().getSimpleName() + "' is greater than position of optional parameter '" + firstOptional.method().getSimpleName() + "'")).collect(Eithers.toOptionalList()));
    }
}

