/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.validate;

import io.jbock.util.Either;
import io.jbock.util.Eithers;
import java.util.List;
import java.util.Optional;
import net.jbock.Parameters;
import net.jbock.annotated.AnnotatedParameters;
import net.jbock.common.ValidationFailure;
import net.jbock.convert.MappingFinder;
import net.jbock.javax.inject.Inject;
import net.jbock.processor.SourceElement;
import net.jbock.validate.ContextBuilder;
import net.jbock.validate.ValidateScope;

@ValidateScope
public class SourceParametersValidator {
    private final MappingFinder mappingFinder;
    private final SourceElement sourceElement;

    @Inject
    SourceParametersValidator(MappingFinder mappingFinder, SourceElement sourceElement) {
        this.mappingFinder = mappingFinder;
        this.sourceElement = sourceElement;
    }

    Either<List<ValidationFailure>, ContextBuilder.Step3> wrapRepeatablePositionalParams(ContextBuilder.Step2 step) {
        return this.validateDuplicateParametersAnnotation(step.repeatablePositionalParameters()).filter(this::validateNoRepeatableParameterInSuperCommand).flatMap(repeatablePositionalParameters -> (Either)repeatablePositionalParameters.stream().map(this.mappingFinder::findMapping).collect(Eithers.toValidListAll())).map(step::accept);
    }

    private Either<List<ValidationFailure>, List<AnnotatedParameters>> validateDuplicateParametersAnnotation(List<AnnotatedParameters> repeatablePositionalParameters) {
        return ((Optional)repeatablePositionalParameters.stream().skip(1L).map(param -> param.fail("duplicate @" + Parameters.class.getSimpleName() + " annotation")).collect(Eithers.toOptionalList())).map(Either::left).orElseGet(() -> Either.right((Object)repeatablePositionalParameters));
    }

    private Optional<List<ValidationFailure>> validateNoRepeatableParameterInSuperCommand(List<AnnotatedParameters> repeatablePositionalParameters) {
        if (!this.sourceElement.isSuperCommand()) {
            return Optional.empty();
        }
        return (Optional)repeatablePositionalParameters.stream().map(param -> param.fail("@" + Parameters.class.getSimpleName() + " cannot be used when superCommand=true")).collect(Eithers.toOptionalList());
    }
}

