/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.jbock.auto.common;

import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;

public enum Visibility {
    PRIVATE,
    DEFAULT,
    PROTECTED,
    PUBLIC;


    public static Visibility ofElement(Element element) {
        Objects.requireNonNull(element);
        if (element.getKind().equals((Object)ElementKind.PACKAGE) || element.getKind().equals((Object)ElementKind.MODULE)) {
            return PUBLIC;
        }
        Set<Modifier> modifiers = element.getModifiers();
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            return PRIVATE;
        }
        if (modifiers.contains((Object)Modifier.PROTECTED)) {
            return PROTECTED;
        }
        if (modifiers.contains((Object)Modifier.PUBLIC)) {
            return PUBLIC;
        }
        return DEFAULT;
    }

    public static Visibility effectiveVisibilityOfElement(Element element) {
        Objects.requireNonNull(element);
        Visibility effectiveVisibility = PUBLIC;
        for (Element currentElement = element; currentElement != null; currentElement = currentElement.getEnclosingElement()) {
            Visibility b = Visibility.ofElement(currentElement);
            effectiveVisibility = effectiveVisibility.compareTo(b) <= 0 ? effectiveVisibility : b;
        }
        return effectiveVisibility;
    }
}

