/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.annotated;

import io.jbock.simple.Inject;
import io.jbock.util.Either;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import net.jbock.common.TypeTool;
import net.jbock.common.ValidationFailure;
import net.jbock.processor.SourceElement;

public class AbstractMethodsFinder {
    private final SourceElement sourceElement;

    @Inject
    public AbstractMethodsFinder(SourceElement sourceElement) {
        this.sourceElement = sourceElement;
    }

    Either<List<ValidationFailure>, List<ExecutableElement>> findAbstractMethods() {
        return this.checkInterfaceOrSimpleClass().or(this::checkNoInterfaces).map(List::of).map(Either::left).orElseGet(() -> Either.right(this.abstractMethods()));
    }

    private Optional<ValidationFailure> checkInterfaceOrSimpleClass() {
        if (this.sourceElement.isInterface()) {
            return Optional.empty();
        }
        return TypeTool.AS_DECLARED.visit(this.sourceElement.element().getSuperclass()).map(DeclaredType::asElement).flatMap(TypeTool.AS_TYPE_ELEMENT::visit).flatMap(superClass -> superClass.getSuperclass().getKind() == TypeKind.NONE ? Optional.empty() : Optional.of(this.sourceElement.fail("invalid superclass: expecting java.lang.Object, but found: " + superClass.getQualifiedName())));
    }

    private Optional<ValidationFailure> checkNoInterfaces() {
        List<? extends TypeMirror> interfaces = this.sourceElement.element().getInterfaces();
        if (interfaces.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.sourceElement.fail("invalid command class: the command class or interface may not implement or extend any interfaces, but found: " + interfaces.stream().map(TypeTool.AS_DECLARED::visit).flatMap(Optional::stream).map(DeclaredType::asElement).map(Element::getSimpleName).collect(Collectors.toList())));
    }

    private List<ExecutableElement> abstractMethods() {
        return ElementFilter.methodsIn(this.sourceElement.element().getEnclosedElements()).stream().filter(m -> m.getModifiers().contains((Object)Modifier.ABSTRACT)).collect(Collectors.toList());
    }
}

