/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.annotated;

import java.lang.annotation.Annotation;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import net.jbock.Option;
import net.jbock.VarargsParameter;
import net.jbock.annotated.Parameter;
import net.jbock.common.Suppliers;
import net.jbock.common.TypeTool;
import net.jbock.common.ValidationFailure;

public abstract class Item {
    private static final Set<Modifier> ACCESS_MODIFIERS = EnumSet.of(Modifier.PUBLIC, Modifier.PROTECTED);
    private final Supplier<Optional<TypeElement>> converter = Suppliers.memoize(() -> {
        String canonicalName = this.annotation().annotationType().getCanonicalName();
        AnnotationMirror annotationMirror = this.method().getAnnotationMirrors().stream().filter(mirror -> TypeTool.AS_TYPE_ELEMENT.visit(mirror.getAnnotationType().asElement()).map(TypeElement::getQualifiedName).map(Object::toString).filter(canonicalName::equals).isPresent()).findFirst().orElseThrow(AssertionError::new);
        return Item.findConverterAttribute(annotationMirror);
    });
    private final ExecutableElement method;
    private final String enumName;

    Item(ExecutableElement method, String enumName) {
        this.method = method;
        this.enumName = enumName;
    }

    static Item create(ExecutableElement method, Annotation annotation, String enumName) {
        if (annotation instanceof Option) {
            return new net.jbock.annotated.Option(method, (Option)annotation, enumName);
        }
        if (annotation instanceof net.jbock.Parameter) {
            return new Parameter(method, (net.jbock.Parameter)annotation, enumName);
        }
        if (annotation instanceof VarargsParameter) {
            return new net.jbock.annotated.VarargsParameter(method, (VarargsParameter)annotation, enumName);
        }
        throw new AssertionError();
    }

    public abstract boolean isParameter();

    public abstract boolean isVarargsParameter();

    public abstract String paramLabel();

    public abstract Optional<String> descriptionKey();

    public abstract List<String> description();

    abstract Annotation annotation();

    public final ExecutableElement method() {
        return this.method;
    }

    final Name simpleName() {
        return this.method.getSimpleName();
    }

    public final List<Modifier> accessModifiers() {
        return this.method().getModifiers().stream().filter(ACCESS_MODIFIERS::contains).collect(Collectors.toList());
    }

    private static Optional<TypeElement> findConverterAttribute(AnnotationMirror annotationMirror) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
        return elementValues.entrySet().stream().filter(e -> "converter".contentEquals(((ExecutableElement)e.getKey()).getSimpleName())).map(Map.Entry::getValue).findFirst().flatMap(TypeTool.ANNOTATION_VALUE_AS_TYPE::visit).flatMap(TypeTool.AS_DECLARED::visit).map(DeclaredType::asElement).flatMap(TypeTool.AS_TYPE_ELEMENT::visit).filter(element -> !"java.lang.Void".contentEquals(element.getQualifiedName()));
    }

    public final Optional<TypeElement> converter() {
        return this.converter.get();
    }

    public final ValidationFailure fail(String message) {
        return new ValidationFailure(message, this.method);
    }

    public final String enumName() {
        return this.enumName;
    }

    public final String methodName() {
        return this.method.getSimpleName().toString();
    }

    public final TypeMirror returnType() {
        return this.method.getReturnType();
    }
}

