/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.annotated;

import io.jbock.util.Either;
import io.jbock.util.Eithers;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import net.jbock.annotated.Item;
import net.jbock.annotated.UniqueNameSet;
import net.jbock.common.Annotations;
import net.jbock.common.SnakeName;
import net.jbock.common.ValidationFailure;

final class ItemListFactory {
    private final UniqueNameSet uniqueNameSet = new UniqueNameSet();

    private ItemListFactory() {
    }

    static Either<List<ValidationFailure>, List<Item>> createItemList(List<ExecutableElement> methods) {
        return new ItemListFactory().validParameterlessAbstract(methods);
    }

    private Either<List<ValidationFailure>, List<Item>> validParameterlessAbstract(List<ExecutableElement> methods) {
        return (Either)methods.stream().map(this::createItem).collect(Eithers.allFailures());
    }

    private Either<ValidationFailure, Item> createItem(ExecutableElement method) {
        String enumName = this.enumNameFor(method.getSimpleName());
        return ItemListFactory.getMethodAnnotation(method).map(a -> Item.create(method, a, enumName));
    }

    private String enumNameFor(Name sourceMethodName) {
        String enumName = "_".contentEquals(sourceMethodName) ? "_1" : SnakeName.create(sourceMethodName).snake('_').toUpperCase(Locale.ROOT);
        return this.uniqueNameSet.getUniqueName(enumName);
    }

    private static Either<ValidationFailure, Annotation> getMethodAnnotation(ExecutableElement method) {
        return Annotations.methodLevelAnnotations().stream().map(method::getAnnotation).filter(Objects::nonNull).findFirst().map(Either::right).orElseGet(() -> Either.left((Object)ItemListFactory.missingAnnotationError(method)));
    }

    private static ValidationFailure missingAnnotationError(ExecutableElement method) {
        String message = "missing annotation: add one of these annotations: " + Annotations.methodLevelAnnotations().stream().map(Class::getSimpleName).collect(Collectors.toList());
        message = message + " to method '" + method.getSimpleName() + "'";
        return new ValidationFailure(message, method);
    }
}

