/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.annotated;

import io.jbock.util.Either;
import io.jbock.util.Eithers;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import net.jbock.annotated.Item;
import net.jbock.common.Annotations;
import net.jbock.common.TypeTool;
import net.jbock.common.Util;
import net.jbock.common.ValidationFailure;

final class ItemListValidator {
    private ItemListValidator() {
    }

    static Either<List<ValidationFailure>, List<Item>> validate(List<Item> items) {
        return (Either)items.stream().map(ItemListValidator::createAnnotatedMethod).collect(Eithers.allFailures());
    }

    private static Either<ValidationFailure, Item> createAnnotatedMethod(Item item) {
        ExecutableElement method = item.method();
        return Util.checkNoDuplicateAnnotations(method, Annotations.methodLevelAnnotations()).map(Either::left).orElseGet(() -> Either.right((Object)item)).filter(ItemListValidator::validateParameterless).filter(ItemListValidator::checkAccessibleReturnType);
    }

    private static Optional<ValidationFailure> validateParameterless(Item method) {
        if (method.method().getParameters().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(method.fail("invalid method parameters: abstract method '" + method.method().getSimpleName() + "' may not have any parameters, but found: " + method.method().getParameters().stream().map(VariableElement::getSimpleName).map(Object::toString).collect(Collectors.toList())));
    }

    private static Optional<ValidationFailure> checkAccessibleReturnType(Item item) {
        return TypeTool.AS_DECLARED.visit(item.returnType()).filter(ItemListValidator::isInaccessible).map(type -> item.fail("inaccessible type: " + Util.typeToString(type)));
    }

    private static boolean isInaccessible(DeclaredType declared) {
        if (declared.asElement().getModifiers().contains((Object)Modifier.PRIVATE)) {
            return true;
        }
        if (TypeTool.AS_TYPE_ELEMENT.visit(declared.asElement()).filter(t -> t.getNestingKind() == NestingKind.MEMBER).filter(t -> !t.getModifiers().contains((Object)Modifier.STATIC)).isPresent()) {
            return true;
        }
        return declared.getTypeArguments().stream().map(TypeTool.AS_DECLARED::visit).flatMap(Optional::stream).anyMatch(ItemListValidator::isInaccessible);
    }
}

