/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.annotated;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.jbock.annotated.Item;
import net.jbock.annotated.Option;
import net.jbock.annotated.Parameter;
import net.jbock.annotated.VarargsParameter;
import net.jbock.common.Constants;

public final class Items {
    private static final Comparator<Parameter> INDEX_COMPARATOR = Comparator.comparingInt(Parameter::index);
    private final List<Option> namedOptions;
    private final List<Parameter> positionalParameters;
    private final List<VarargsParameter> varargsParameters;

    private Items(List<Option> namedOptions, List<Parameter> positionalParameters, List<VarargsParameter> varargsParameters) {
        this.namedOptions = namedOptions;
        this.positionalParameters = positionalParameters;
        this.varargsParameters = varargsParameters;
    }

    static Items createItems(List<? extends Item> itemList) {
        return new Items(itemList.stream().flatMap(Constants.instancesOf(Option.class)).collect(Collectors.toList()), itemList.stream().flatMap(Constants.instancesOf(Parameter.class)).sorted(INDEX_COMPARATOR).collect(Collectors.toList()), itemList.stream().flatMap(Constants.instancesOf(VarargsParameter.class)).collect(Collectors.toList()));
    }

    public List<Option> namedOptions() {
        return this.namedOptions;
    }

    public List<Parameter> positionalParameters() {
        return this.positionalParameters;
    }

    public List<VarargsParameter> varargsParameters() {
        return this.varargsParameters;
    }
}

