/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.annotated;

import io.jbock.simple.Inject;
import io.jbock.util.Either;
import java.util.List;
import java.util.Optional;
import net.jbock.annotated.AbstractMethodsFinder;
import net.jbock.annotated.ItemListFactory;
import net.jbock.annotated.ItemListValidator;
import net.jbock.annotated.Items;
import net.jbock.common.ValidationFailure;
import net.jbock.processor.SourceElement;

public class ItemsFactory {
    private final SourceElement sourceElement;
    private final AbstractMethodsFinder abstractMethodsFinder;

    @Inject
    public ItemsFactory(SourceElement sourceElement, AbstractMethodsFinder abstractMethodsFinder) {
        this.sourceElement = sourceElement;
        this.abstractMethodsFinder = abstractMethodsFinder;
    }

    public Either<List<ValidationFailure>, Items> createItems() {
        return this.abstractMethodsFinder.findAbstractMethods().flatMap(ItemListFactory::createItemList).flatMap(ItemListValidator::validate).map(Items::createItems).filter(this::validateAtLeastOneParameterInSuperCommand);
    }

    private Optional<List<ValidationFailure>> validateAtLeastOneParameterInSuperCommand(Items items) {
        if (!this.sourceElement.isSuperCommand() || !items.positionalParameters().isEmpty()) {
            return Optional.empty();
        }
        String message = "At least one @Parameter must be defined in a @SuperCommand";
        return Optional.of(List.of(this.sourceElement.fail(message)));
    }
}

