/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.annotated;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import net.jbock.annotated.Item;
import net.jbock.common.Constants;
import net.jbock.common.SnakeName;
import net.jbock.common.Suppliers;

public final class Option
extends Item {
    private static final Comparator<String> LENGTH_FIRST_COMPARATOR = Comparator.comparing(String::length).thenComparing(String::toString);
    private final Supplier<List<String>> names = Suppliers.memoize(() -> this.optionNames().stream().sorted(LENGTH_FIRST_COMPARATOR).collect(Collectors.toList()));
    private final Supplier<String> paramLabel = Suppliers.memoize(() -> this.optionParamLabel().or(() -> this.optionNames().stream().filter(name -> name.startsWith("--")).map(name -> name.substring(2)).map(s -> s.toUpperCase(Locale.ROOT)).findFirst()).orElseGet(() -> SnakeName.create(this.simpleName()).snake('_').toUpperCase(Locale.ROOT)));
    private final net.jbock.Option option;

    Option(ExecutableElement method, net.jbock.Option option, String enumName) {
        super(method, enumName);
        this.option = option;
    }

    @Override
    public Optional<String> descriptionKey() {
        return Constants.optionalString(this.option.descriptionKey());
    }

    @Override
    public List<String> description() {
        return List.of(this.option.description());
    }

    @Override
    Annotation annotation() {
        return this.option;
    }

    @Override
    public String paramLabel() {
        return this.paramLabel.get();
    }

    @Override
    public boolean isParameter() {
        return false;
    }

    @Override
    public boolean isVarargsParameter() {
        return false;
    }

    public List<String> names() {
        return this.names.get();
    }

    private List<String> optionNames() {
        return List.of(this.option.names());
    }

    private Optional<String> optionParamLabel() {
        return Constants.optionalString(this.option.paramLabel());
    }
}

