/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.common;

import io.jbock.simple.Inject;
import java.util.Optional;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.util.SimpleAnnotationValueVisitor9;
import javax.lang.model.util.SimpleElementVisitor9;
import javax.lang.model.util.SimpleTypeVisitor9;
import net.jbock.common.SafeElements;
import net.jbock.common.SafeTypes;

public final class TypeTool {
    public static final TypeVisitor<Optional<DeclaredType>, Void> AS_DECLARED = new OptionalTypeVisitor<DeclaredType>(){

        @Override
        public Optional<DeclaredType> visitDeclared(DeclaredType declaredType, Void nothing) {
            return Optional.of(declaredType);
        }
    };
    public static final TypeVisitor<Optional<PrimitiveType>, Void> AS_PRIMITIVE = new OptionalTypeVisitor<PrimitiveType>(){

        @Override
        public Optional<PrimitiveType> visitPrimitive(PrimitiveType primitiveType, Void nothing) {
            return Optional.of(primitiveType);
        }
    };
    public static final ElementVisitor<Optional<TypeElement>, Void> AS_TYPE_ELEMENT = new SimpleElementVisitor9<Optional<TypeElement>, Void>(){

        @Override
        public Optional<TypeElement> visitType(TypeElement typeElement, Void nothing) {
            return Optional.of(typeElement);
        }

        @Override
        protected Optional<TypeElement> defaultAction(Element e, Void nothing) {
            return Optional.empty();
        }
    };
    public static final AnnotationValueVisitor<Optional<TypeMirror>, Void> ANNOTATION_VALUE_AS_TYPE = new SimpleAnnotationValueVisitor9<Optional<TypeMirror>, Void>(){

        @Override
        public Optional<TypeMirror> visitType(TypeMirror mirror, Void nothing) {
            return Optional.of(mirror);
        }

        @Override
        protected Optional<TypeMirror> defaultAction(Object o, Void nothing) {
            return Optional.empty();
        }
    };
    private final SafeTypes types;
    private final SafeElements elements;

    @Inject
    public TypeTool(SafeElements elements, SafeTypes types) {
        this.types = types;
        this.elements = elements;
    }

    public boolean isSameType(TypeMirror mirror, Class<?> cl) {
        return this.isSameType(mirror, cl.getCanonicalName());
    }

    public boolean isListOfString(TypeMirror mirror) {
        Optional<DeclaredType> visit = AS_DECLARED.visit(mirror);
        if (visit.isEmpty()) {
            return false;
        }
        DeclaredType declaredType = visit.orElseThrow();
        if (declaredType.getTypeArguments().isEmpty()) {
            return false;
        }
        if (this.elements.getTypeElement("java.util.List").filter(list -> list.equals(declaredType.asElement())).isEmpty()) {
            return false;
        }
        return this.isSameType(declaredType.getTypeArguments().get(0), String.class);
    }

    public boolean isSameType(TypeMirror mirror, String canonicalName) {
        return this.elements.getTypeElement(canonicalName).map(TypeElement::asType).map(type -> this.types.isSameType(mirror, (TypeMirror)type)).orElse(false);
    }

    public Optional<TypeMirror> getSingleTypeArgument(TypeMirror mirror, TypeElement someClass) {
        return AS_DECLARED.visit(mirror).filter(declaredType -> declaredType.getTypeArguments().size() == 1).filter(declaredType -> this.types.isSameType(this.types.erasure((TypeMirror)declaredType), this.types.erasure(someClass.asType()))).map(declaredType -> declaredType.getTypeArguments().get(0));
    }

    public SafeTypes types() {
        return this.types;
    }

    public SafeElements elements() {
        return this.elements;
    }

    private static abstract class OptionalTypeVisitor<E>
    extends SimpleTypeVisitor9<Optional<E>, Void> {
        private OptionalTypeVisitor() {
        }

        @Override
        protected final Optional<E> defaultAction(TypeMirror e, Void nothing) {
            return Optional.empty();
        }
    }
}

