/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.common;

import io.jbock.simple.Inject;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import net.jbock.common.SafeTypes;
import net.jbock.common.TypeTool;
import net.jbock.common.ValidationFailure;

public final class Util {
    private final SafeTypes types;
    private final TypeTool tool;

    @Inject
    public Util(SafeTypes types, TypeTool tool) {
        this.types = types;
        this.tool = tool;
    }

    public Optional<ValidationFailure> commonTypeChecks(TypeElement classToCheck) {
        return this.checkNesting(classToCheck).map(f -> f.prepend("invalid class: ")).or(() -> this.checkDefaultConstructor(classToCheck));
    }

    private Optional<ValidationFailure> checkNesting(TypeElement classToCheck) {
        if (classToCheck.getNestingKind().isNested() && !classToCheck.getModifiers().contains((Object)Modifier.STATIC)) {
            return Optional.of(new ValidationFailure("nested class '" + classToCheck.getSimpleName() + "' must be static", classToCheck));
        }
        if (classToCheck.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return Optional.of(new ValidationFailure("class '" + classToCheck.getSimpleName() + " may not be private", classToCheck));
        }
        for (TypeElement element : this.getEnclosingElements(classToCheck)) {
            if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
                return Optional.of(new ValidationFailure("enclosing class '" + element.getSimpleName() + "' may not be private", element));
            }
            if (!element.getNestingKind().isNested() || element.getModifiers().contains((Object)Modifier.STATIC)) continue;
            return Optional.of(new ValidationFailure("nested class '" + element.getSimpleName() + "' must be static", element));
        }
        return Optional.empty();
    }

    private Optional<ValidationFailure> checkDefaultConstructor(TypeElement classToCheck) {
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(classToCheck.getEnclosedElements());
        if (constructors.isEmpty()) {
            return Optional.empty();
        }
        return constructors.stream().filter(c -> c.getParameters().isEmpty()).map(c -> {
            if (c.getModifiers().contains((Object)Modifier.PRIVATE)) {
                return Optional.of(new ValidationFailure("invalid constructor: visibility may not be private", (Element)c));
            }
            return this.checkExceptionsInDeclaration((ExecutableElement)c);
        }).flatMap(Optional::stream).findAny().or(() -> {
            if (constructors.stream().anyMatch(c -> c.getParameters().isEmpty())) {
                return Optional.empty();
            }
            return Optional.of(new ValidationFailure("invalid class: default constructor not found", classToCheck));
        });
    }

    public Optional<ValidationFailure> checkExceptionsInDeclaration(ExecutableElement element) {
        return element.getThrownTypes().stream().map(thrown -> this.checkChecked(element, (TypeMirror)thrown, (TypeMirror)thrown)).flatMap(Optional::stream).findAny();
    }

    private Optional<ValidationFailure> checkChecked(ExecutableElement element, TypeMirror thrown, TypeMirror mirror) {
        if (this.tool.isSameType(mirror, RuntimeException.class) || this.tool.isSameType(mirror, Error.class)) {
            return Optional.empty();
        }
        if (this.tool.isSameType(mirror, Throwable.class)) {
            return Optional.of(new ValidationFailure("invalid throws clause: found checked exception " + Util.typeToString(thrown), element));
        }
        return this.types.asElement(mirror).flatMap(TypeTool.AS_TYPE_ELEMENT::visit).flatMap(t -> this.checkNesting((TypeElement)t).map(f -> f.prepend("invalid throws clause: declared exception " + Util.typeToString(thrown) + " is invalid: ").about(element)).or(() -> this.checkChecked(element, thrown, t.getSuperclass())));
    }

    public List<TypeElement> getEnclosingElements(TypeElement sourceElement) {
        Optional<TypeElement> enclosing;
        if (sourceElement.getNestingKind() != NestingKind.MEMBER) {
            return List.of();
        }
        ArrayList<TypeElement> result = new ArrayList<TypeElement>();
        TypeElement current = sourceElement;
        while (current.getNestingKind() == NestingKind.MEMBER && !(enclosing = TypeTool.AS_TYPE_ELEMENT.visit(current.getEnclosingElement())).isEmpty()) {
            TypeElement e = enclosing.orElseThrow();
            result.add(e);
            current = e;
        }
        return result;
    }

    public static String typeToString(TypeMirror type) {
        return TypeTool.AS_DECLARED.visit(type).flatMap(declared -> TypeTool.AS_TYPE_ELEMENT.visit(declared.asElement()).map(t -> {
            String base = t.getSimpleName().toString();
            if (declared.getTypeArguments().isEmpty()) {
                return base;
            }
            return base + declared.getTypeArguments().stream().map(Util::typeToString).collect(Collectors.joining(", ", "<", ">"));
        })).orElseGet(type::toString);
    }

    public static Optional<ValidationFailure> checkNoDuplicateAnnotations(Element element, List<Class<? extends Annotation>> annotations) {
        List present = annotations.stream().filter(ann -> element.getAnnotation(ann) != null).collect(Collectors.toList());
        if (present.size() >= 2) {
            return Optional.of(new ValidationFailure("annotate with either @" + ((Class)present.get(0)).getSimpleName() + " or @" + ((Class)present.get(1)).getSimpleName() + ", but not both", element));
        }
        return Optional.empty();
    }
}

