/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.convert;

import io.jbock.jbock.javapoet.CodeBlock;
import io.jbock.jbock.javapoet.FieldSpec;
import io.jbock.jbock.javapoet.TypeName;
import java.util.Optional;
import java.util.function.Supplier;
import javax.lang.model.element.Modifier;
import net.jbock.annotated.Item;
import net.jbock.common.Suppliers;
import net.jbock.convert.match.Match;
import net.jbock.model.Multiplicity;

public final class Mapping<M extends Item> {
    private final CodeBlock createConverterExpression;
    private final Match<M> match;
    private final boolean nullary;
    private final Supplier<FieldSpec> fieldSupplier = Suppliers.memoize(() -> {
        TypeName fieldType = TypeName.get(((Item)this.item()).returnType());
        String fieldName = ((Item)this.item()).methodName();
        return FieldSpec.builder(fieldType, fieldName, Modifier.FINAL).build();
    });

    private Mapping(CodeBlock createConverterExpression, Match<M> match, boolean nullary) {
        this.createConverterExpression = createConverterExpression;
        this.match = match;
        this.nullary = nullary;
    }

    public static <M extends Item> Mapping<M> create(CodeBlock createConverterExpression, Match<M> match) {
        return Mapping.create(createConverterExpression, match, false);
    }

    public static <M extends Item> Mapping<M> create(CodeBlock createConverterExpression, Match<M> match, boolean nullary) {
        return new Mapping<M>(createConverterExpression, match, nullary);
    }

    public CodeBlock createConverterExpression() {
        return this.createConverterExpression;
    }

    public Optional<CodeBlock> extractExpr() {
        return this.match.extractExpr();
    }

    public Multiplicity multiplicity() {
        return this.match.multiplicity();
    }

    public String enumName() {
        return ((Item)this.item()).enumName();
    }

    public boolean isRequired() {
        return this.multiplicity() == Multiplicity.REQUIRED;
    }

    public boolean isRepeatable() {
        return this.multiplicity() == Multiplicity.REPEATABLE;
    }

    public boolean isOptional() {
        return this.multiplicity() == Multiplicity.OPTIONAL;
    }

    public boolean isNullary() {
        return this.nullary;
    }

    public M item() {
        return this.match.item();
    }

    public String paramLabel() {
        return ((Item)this.item()).paramLabel();
    }

    public FieldSpec field() {
        return this.fieldSupplier.get();
    }
}

