/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.convert;

import io.jbock.jbock.javapoet.CodeBlock;
import io.jbock.simple.Inject;
import io.jbock.util.Either;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import net.jbock.annotated.Item;
import net.jbock.common.Util;
import net.jbock.common.ValidationFailure;
import net.jbock.convert.Mapping;
import net.jbock.convert.map.AutoOrEnumMapper;
import net.jbock.convert.map.ConverterValidator;
import net.jbock.convert.match.Match;
import net.jbock.convert.match.MatchFinder;
import net.jbock.processor.SourceElement;
import net.jbock.util.StringConverter;

public final class MappingFinder {
    private final AutoOrEnumMapper autoOrEnumMapper;
    private final ConverterValidator converterValidator;
    private final SourceElement sourceElement;
    private final Util util;
    private final MatchFinder matchFinder;

    @Inject
    public MappingFinder(AutoOrEnumMapper autoOrEnumMapper, ConverterValidator converterValidator, SourceElement sourceElement, Util util, MatchFinder matchFinder) {
        this.autoOrEnumMapper = autoOrEnumMapper;
        this.converterValidator = converterValidator;
        this.sourceElement = sourceElement;
        this.util = util;
        this.matchFinder = matchFinder;
    }

    public <M extends Item> Either<ValidationFailure, Mapping<M>> findMapping(M item) {
        return this.matchFinder.findMatch(item).flatMap(this::findMappingWithMatch);
    }

    public <M extends Item> Either<ValidationFailure, Mapping<M>> findNullaryMapping(M item) {
        return this.matchFinder.createNullaryMatch(item).map(match -> Mapping.create(CodeBlock.of("$T.identity())", StringConverter.class), match, true));
    }

    private <M extends Item> Either<ValidationFailure, Mapping<M>> findMappingWithMatch(Match<M> match) {
        return ((Item)match.item()).converter().map(converter -> this.checkConverterIsInnerClass(match.item(), (TypeElement)converter).or(() -> this.util.commonTypeChecks((TypeElement)converter)).or(() -> this.checkNotAbstract(match.item(), (TypeElement)converter)).or(() -> this.checkNoTypeVars(match.item(), (TypeElement)converter)).map(failure -> failure.prepend("invalid converter class: ")).map(Either::left).orElseGet(() -> Either.right((Object)converter)).flatMap(c -> this.converterValidator.findMapping(match, (TypeElement)c))).orElseGet(() -> this.autoOrEnumMapper.findMapping(match));
    }

    private <M extends Item> Optional<ValidationFailure> checkConverterIsInnerClass(M item, TypeElement converter) {
        boolean nested = this.util.getEnclosingElements(converter).contains(this.sourceElement.element());
        if (!nested) {
            return Optional.of(item.fail("converter of '" + item.methodName() + "' must be an inner class of the command class '" + this.sourceElement.element().getSimpleName() + "'"));
        }
        return Optional.empty();
    }

    private <M extends Item> Optional<ValidationFailure> checkNotAbstract(M item, TypeElement converter) {
        if (converter.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return Optional.of(item.fail("the converter class '" + converter.getSimpleName() + "' may not be abstract"));
        }
        return Optional.empty();
    }

    private <M extends Item> Optional<ValidationFailure> checkNoTypeVars(M item, TypeElement converter) {
        if (!converter.getTypeParameters().isEmpty()) {
            return Optional.of(item.fail("type parameters are not allowed in the declaration of converter class '" + converter.getSimpleName() + "'"));
        }
        return Optional.empty();
    }
}

