/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.convert.map;

import io.jbock.jbock.javapoet.CodeBlock;
import io.jbock.simple.Inject;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.lang.model.type.TypeMirror;
import net.jbock.annotated.Item;
import net.jbock.common.TypeTool;
import net.jbock.contrib.StandardConverters;
import net.jbock.convert.Mapping;
import net.jbock.convert.match.Match;

public final class AutoMappings {
    private final TypeTool tool;

    @Inject
    public AutoMappings(TypeTool tool) {
        this.tool = tool;
    }

    <M extends Item> Optional<Mapping<M>> findAutoMapping(Match<M> match) {
        TypeMirror baseType = match.baseType();
        if (this.tool.isSameType(baseType, String.class)) {
            return Optional.of(AutoMappings.createMapping("asString", match));
        }
        if (this.tool.isSameType(baseType, Integer.class)) {
            return Optional.of(AutoMappings.createMapping("asInteger", match));
        }
        if (this.tool.isSameType(baseType, Path.class)) {
            return Optional.of(AutoMappings.createMapping("asPath", match));
        }
        if (this.tool.isSameType(baseType, File.class)) {
            return Optional.of(AutoMappings.createMapping("asExistingFile", match));
        }
        if (this.tool.isSameType(baseType, URI.class)) {
            return Optional.of(AutoMappings.createMapping("asURI", match));
        }
        if (this.tool.isSameType(baseType, Pattern.class)) {
            return Optional.of(AutoMappings.createMapping("asPattern", match));
        }
        if (this.tool.isSameType(baseType, LocalDate.class)) {
            return Optional.of(AutoMappings.createMapping("asLocalDate", match));
        }
        if (this.tool.isSameType(baseType, Long.class)) {
            return Optional.of(AutoMappings.createMapping("asLong", match));
        }
        if (this.tool.isSameType(baseType, Short.class)) {
            return Optional.of(AutoMappings.createMapping("asShort", match));
        }
        if (this.tool.isSameType(baseType, Byte.class)) {
            return Optional.of(AutoMappings.createMapping("asByte", match));
        }
        if (this.tool.isSameType(baseType, Float.class)) {
            return Optional.of(AutoMappings.createMapping("asFloat", match));
        }
        if (this.tool.isSameType(baseType, Double.class)) {
            return Optional.of(AutoMappings.createMapping("asDouble", match));
        }
        if (this.tool.isSameType(baseType, Character.class)) {
            return Optional.of(AutoMappings.createMapping("asCharacter", match));
        }
        if (this.tool.isSameType(baseType, BigInteger.class)) {
            return Optional.of(AutoMappings.createMapping("asBigInteger", match));
        }
        if (this.tool.isSameType(baseType, BigDecimal.class)) {
            return Optional.of(AutoMappings.createMapping("asBigDecimal", match));
        }
        return Optional.empty();
    }

    private static <M extends Item> Mapping<M> createMapping(String methodName, Match<M> match) {
        CodeBlock createConverterExpression = CodeBlock.of("$T.$L()", StandardConverters.class, methodName);
        return Mapping.create(createConverterExpression, match);
    }
}

