/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.convert.map;

import io.jbock.simple.Inject;
import io.jbock.util.Either;
import java.util.Optional;
import java.util.function.Supplier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import net.jbock.annotated.Item;
import net.jbock.common.SafeElements;
import net.jbock.common.SafeTypes;
import net.jbock.common.TypeTool;
import net.jbock.common.ValidationFailure;
import net.jbock.convert.Mapping;
import net.jbock.convert.map.MappingFactory;
import net.jbock.convert.match.Match;
import net.jbock.util.StringConverter;

public final class ConverterValidator {
    private final SafeTypes types;
    private final SafeElements elements;
    private final MappingFactory.Factory mappingFactoryFactory;

    @Inject
    public ConverterValidator(TypeTool tool, MappingFactory.Factory mappingFactoryFactory) {
        this.types = tool.types();
        this.elements = tool.elements();
        this.mappingFactoryFactory = mappingFactoryFactory;
    }

    public <M extends Item> Either<ValidationFailure, Mapping<M>> findMapping(Match<M> match, TypeElement converter) {
        return this.checkSuppliedConverter(converter, match).or(() -> this.checkDirectConverter(converter, match)).orElseGet(() -> Either.left((Object)match.fail(this.errorConverterType()))).flatMap(MappingFactory::checkMatchingMatch);
    }

    private <M extends Item> Either<ValidationFailure, MappingFactory<M>> handleConverter(TypeElement converter, Match<M> match, DeclaredType converterType, boolean isSupplier) {
        if (converterType.getTypeArguments().size() != 1) {
            return Either.left((Object)match.fail(this.converterRawType(converterType)));
        }
        TypeMirror typeArgument = converterType.getTypeArguments().get(0);
        return Either.right(this.mappingFactoryFactory.create(converter, typeArgument, match, isSupplier));
    }

    private <M extends Item> Optional<Either<ValidationFailure, MappingFactory<M>>> checkSuppliedConverter(TypeElement converter, Match<M> match) {
        return converter.getInterfaces().stream().filter(inter -> this.isSameErasure((TypeMirror)inter, Supplier.class)).map(TypeTool.AS_DECLARED::visit).flatMap(Optional::stream).findFirst().map(declaredType -> this.checkSuppliedConverter(converter, match, (DeclaredType)declaredType));
    }

    private <M extends Item> Either<ValidationFailure, MappingFactory<M>> checkSuppliedConverter(TypeElement converter, Match<M> match, DeclaredType supplierType) {
        if (supplierType.getTypeArguments().size() != 1) {
            return Either.left((Object)match.fail(this.converterRawType(supplierType)));
        }
        return TypeTool.AS_DECLARED.visit(supplierType.getTypeArguments().get(0)).filter(typeArgument -> this.isSameErasure((TypeMirror)typeArgument, StringConverter.class)).map(Either::right).orElseGet(() -> Either.left((Object)match.fail(this.errorConverterType()))).flatMap(suppliedType -> this.handleConverter(converter, match, (DeclaredType)suppliedType, true));
    }

    private <M extends Item> Optional<Either<ValidationFailure, MappingFactory<M>>> checkDirectConverter(TypeElement converter, Match<M> match) {
        return Optional.of(converter.getSuperclass()).filter(inter -> this.isSameErasure((TypeMirror)inter, StringConverter.class)).flatMap(TypeTool.AS_DECLARED::visit).map(converterType -> this.handleConverter(converter, match, (DeclaredType)converterType, false));
    }

    private boolean isSameErasure(TypeMirror x, Class<?> y) {
        return this.elements.getTypeElement(y.getCanonicalName()).map(TypeElement::asType).map(type -> this.types.isSameType(this.types.erasure(x), this.types.erasure((TypeMirror)type))).orElse(false);
    }

    private String errorConverterType() {
        return "invalid converter class: converter must extend " + StringConverter.class.getSimpleName() + "<X> or implement " + Supplier.class.getSimpleName() + "<" + StringConverter.class.getSimpleName() + "<X>>";
    }

    private String converterRawType(DeclaredType declaredType) {
        return "invalid converter class: missing a type parameter in type '" + declaredType.asElement().getSimpleName() + "'";
    }
}

