/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.convert.match;

import java.util.Optional;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import net.jbock.annotated.Item;
import net.jbock.common.SafeElements;
import net.jbock.common.TypeTool;
import net.jbock.convert.match.Match;
import net.jbock.convert.match.Matcher;
import net.jbock.model.Multiplicity;

final class ListMatcher
extends Matcher {
    private final SafeElements elements;
    private final TypeTool tool;

    ListMatcher(TypeTool tool) {
        this.elements = tool.elements();
        this.tool = tool;
    }

    @Override
    <M extends Item> Optional<Match<M>> tryMatch(M item) {
        if (item.isParameter()) {
            return Optional.empty();
        }
        TypeMirror returnType = item.returnType();
        return this.elements.getTypeElement("java.util.List").flatMap(utilList -> this.tool.getSingleTypeArgument(returnType, (TypeElement)utilList)).map(typeArg -> Match.create(typeArg, Multiplicity.REPEATABLE, item));
    }
}

