/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.convert.match;

import io.jbock.jbock.javapoet.CodeBlock;
import java.util.Optional;
import javax.lang.model.type.TypeMirror;
import net.jbock.annotated.Item;
import net.jbock.common.ValidationFailure;
import net.jbock.model.Multiplicity;

public final class Match<M extends Item> {
    private final TypeMirror baseType;
    private final Optional<CodeBlock> extractExpr;
    private final Multiplicity multiplicity;
    private final M item;

    private Match(TypeMirror baseType, Multiplicity multiplicity, Optional<CodeBlock> extractExpr, M item) {
        this.baseType = baseType;
        this.multiplicity = multiplicity;
        this.extractExpr = extractExpr;
        this.item = item;
    }

    static <M extends Item> Match<M> createWithExtract(TypeMirror baseType, CodeBlock extractExpr, M item) {
        return new Match<M>(baseType, Multiplicity.OPTIONAL, Optional.of(extractExpr), item);
    }

    static <M extends Item> Match<M> create(TypeMirror baseType, Multiplicity multiplicity, M item) {
        return new Match<M>(baseType, multiplicity, Optional.empty(), item);
    }

    public TypeMirror baseType() {
        return this.baseType;
    }

    public Multiplicity multiplicity() {
        return this.multiplicity;
    }

    public M item() {
        return this.item;
    }

    public ValidationFailure fail(String message) {
        return ((Item)this.item()).fail(message);
    }

    public Optional<CodeBlock> extractExpr() {
        return this.extractExpr;
    }
}

