/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.convert.match;

import io.jbock.simple.Inject;
import io.jbock.util.Either;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import net.jbock.VarargsParameter;
import net.jbock.annotated.Item;
import net.jbock.common.SafeTypes;
import net.jbock.common.TypeTool;
import net.jbock.common.ValidationFailure;
import net.jbock.convert.match.Match;
import net.jbock.convert.match.Matcher;
import net.jbock.model.Multiplicity;

public final class MatchFinder {
    private final Set<Matcher> matchers;
    private final SafeTypes types;

    @Inject
    public MatchFinder(Set<Matcher> matchers, TypeTool tool) {
        this.matchers = matchers;
        this.types = tool.types();
    }

    public <M extends Item> Either<ValidationFailure, Match<M>> findMatch(M item) {
        Match match = this.findMatchInternal(item);
        return this.validateVarargsIsList(match).map(Either::left).orElseGet(() -> Either.right((Object)match));
    }

    public <M extends Item> Either<ValidationFailure, Match<M>> createNullaryMatch(M item) {
        PrimitiveType bool = this.types.getPrimitiveType(TypeKind.BOOLEAN);
        Match match = Match.create(bool, Multiplicity.OPTIONAL, item);
        return this.validateVarargsIsList(match).map(Either::left).orElseGet(() -> Either.right((Object)match));
    }

    private <M extends Item> Match<M> findMatchInternal(M item) {
        return this.matchers.stream().map(matcher -> matcher.tryMatch(item)).flatMap(Optional::stream).findFirst().orElseGet(() -> {
            TypeMirror baseType = TypeTool.AS_PRIMITIVE.visit(item.returnType()).map(this.types::boxedClass).map(TypeElement::asType).orElse(item.returnType());
            return Match.create(baseType, Multiplicity.REQUIRED, item);
        });
    }

    private <M extends Item> Optional<ValidationFailure> validateVarargsIsList(Match<M> match) {
        M item = match.item();
        if (((Item)item).isVarargsParameter() && match.multiplicity() != Multiplicity.REPEATABLE) {
            return Optional.of(((Item)item).fail("method '" + ((Item)item).method().getSimpleName() + "' is annotated with @" + VarargsParameter.class.getSimpleName() + ", so it must return java.util.List"));
        }
        return Optional.empty();
    }
}

