/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.convert.match;

import io.jbock.jbock.javapoet.CodeBlock;
import java.util.Optional;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import net.jbock.annotated.Item;
import net.jbock.common.SafeElements;
import net.jbock.common.TypeTool;
import net.jbock.convert.match.Match;
import net.jbock.convert.match.Matcher;
import net.jbock.convert.match.OptionalPrimitive;
import net.jbock.model.Multiplicity;

final class OptionalMatcher
extends Matcher {
    private final TypeTool tool;
    private final SafeElements elements;

    OptionalMatcher(TypeTool tool) {
        this.tool = tool;
        this.elements = tool.elements();
    }

    @Override
    <M extends Item> Optional<Match<M>> tryMatch(M item) {
        if (item.isVarargsParameter()) {
            return Optional.empty();
        }
        TypeMirror returnType = item.returnType();
        return this.getOptionalPrimitive(item, returnType).or(() -> this.matchOptional(item, returnType));
    }

    private <M extends Item> Optional<Match<M>> matchOptional(M item, TypeMirror returnType) {
        return this.elements.getTypeElement("java.util.Optional").flatMap(el -> this.tool.getSingleTypeArgument(returnType, (TypeElement)el)).map(typeArg -> Match.create(typeArg, Multiplicity.OPTIONAL, item));
    }

    private <M extends Item> Optional<Match<M>> getOptionalPrimitive(M item, TypeMirror type) {
        for (OptionalPrimitive optionalPrimitive : OptionalPrimitive.values()) {
            if (!this.tool.isSameType(type, optionalPrimitive.type())) continue;
            CodeBlock extractExpr = optionalPrimitive.extractExpr();
            return this.elements.getTypeElement(optionalPrimitive.numberType()).map(TypeElement::asType).map(numberType -> Match.createWithExtract(numberType, extractExpr, item));
        }
        return Optional.empty();
    }
}

